/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import java.util.AbstractList;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.fs.FsProbe;

public class FsInfo
extends AbstractList<Path>
implements Writeable {
    private final long timestamp;
    private final Path[] paths;
    private final IoStats ioStats;
    private final Path total;
    private final DiskUsage leastDiskEstimate;
    private final DiskUsage mostDiskEstimate;

    public FsInfo(long timestamp, IoStats ioStats, Path[] paths) {
        this(timestamp, ioStats, paths, null, null);
    }

    public FsInfo(long timestamp, IoStats ioStats, Path[] paths, @Nullable DiskUsage leastUsage, @Nullable DiskUsage mostUsage) {
        this.timestamp = timestamp;
        this.ioStats = ioStats;
        this.paths = paths;
        this.total = this.total();
        this.leastDiskEstimate = leastUsage;
        this.mostDiskEstimate = mostUsage;
    }

    public FsInfo(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.ioStats = in.readOptionalWriteable(IoStats::new);
        this.paths = new Path[in.readVInt()];
        for (int i = 0; i < this.paths.length; ++i) {
            this.paths[i] = new Path(in);
        }
        this.total = this.total();
        this.leastDiskEstimate = in.readOptionalWriteable(DiskUsage::new);
        this.mostDiskEstimate = in.readOptionalWriteable(DiskUsage::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeOptionalWriteable(this.ioStats);
        out.writeVInt(this.paths.length);
        for (Path path : this.paths) {
            path.writeTo(out);
        }
        out.writeOptionalWriteable(this.leastDiskEstimate);
        out.writeOptionalWriteable(this.mostDiskEstimate);
    }

    public Path getTotal() {
        return this.total;
    }

    @Nullable
    public DiskUsage getLeastDiskEstimate() {
        return this.leastDiskEstimate;
    }

    @Nullable
    public DiskUsage getMostDiskEstimate() {
        return this.mostDiskEstimate;
    }

    private Path total() {
        Path res = new Path();
        HashSet<String> seenDevices = new HashSet<String>(this.paths.length);
        for (Path subPath : this.paths) {
            if (subPath.path != null && !seenDevices.add(subPath.path)) continue;
            res.add(subPath);
        }
        return res;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public IoStats getIoStats() {
        return this.ioStats;
    }

    @Override
    public Path get(int index) {
        return this.paths[index];
    }

    @Override
    public int size() {
        return this.paths.length;
    }

    public static class IoStats
    implements Writeable {
        final DeviceStats[] devicesStats;
        final long totalOperations;
        final long totalReadOperations;
        final long totalWriteOperations;
        final long totalReadKilobytes;
        final long totalWriteKilobytes;

        public IoStats(DeviceStats[] devicesStats) {
            this.devicesStats = devicesStats;
            long totalOperations = 0L;
            long totalReadOperations = 0L;
            long totalWriteOperations = 0L;
            long totalReadKilobytes = 0L;
            long totalWriteKilobytes = 0L;
            for (DeviceStats deviceStats : devicesStats) {
                totalOperations += deviceStats.operations() != -1L ? deviceStats.operations() : 0L;
                totalReadOperations += deviceStats.readOperations() != -1L ? deviceStats.readOperations() : 0L;
                totalWriteOperations += deviceStats.writeOperations() != -1L ? deviceStats.writeOperations() : 0L;
                totalReadKilobytes += deviceStats.readKilobytes() != -1L ? deviceStats.readKilobytes() : 0L;
                totalWriteKilobytes += deviceStats.writeKilobytes() != -1L ? deviceStats.writeKilobytes() : 0L;
            }
            this.totalOperations = totalOperations;
            this.totalReadOperations = totalReadOperations;
            this.totalWriteOperations = totalWriteOperations;
            this.totalReadKilobytes = totalReadKilobytes;
            this.totalWriteKilobytes = totalWriteKilobytes;
        }

        public IoStats(StreamInput in) throws IOException {
            int length = in.readVInt();
            DeviceStats[] devicesStats = new DeviceStats[length];
            for (int i = 0; i < length; ++i) {
                devicesStats[i] = new DeviceStats(in);
            }
            this.devicesStats = devicesStats;
            this.totalOperations = in.readLong();
            this.totalReadOperations = in.readLong();
            this.totalWriteOperations = in.readLong();
            this.totalReadKilobytes = in.readLong();
            this.totalWriteKilobytes = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.devicesStats.length);
            for (int i = 0; i < this.devicesStats.length; ++i) {
                this.devicesStats[i].writeTo(out);
            }
            out.writeLong(this.totalOperations);
            out.writeLong(this.totalReadOperations);
            out.writeLong(this.totalWriteOperations);
            out.writeLong(this.totalReadKilobytes);
            out.writeLong(this.totalWriteKilobytes);
        }

        public DeviceStats[] getDevicesStats() {
            return this.devicesStats;
        }

        public long getTotalOperations() {
            return this.totalOperations;
        }

        public long getTotalReadOperations() {
            return this.totalReadOperations;
        }

        public long getTotalWriteOperations() {
            return this.totalWriteOperations;
        }

        public long getTotalReadKilobytes() {
            return this.totalReadKilobytes;
        }

        public long getTotalWriteKilobytes() {
            return this.totalWriteKilobytes;
        }
    }

    public static class Path
    implements Writeable {
        String path;
        @Nullable
        String mount;
        @Nullable
        String type;
        long total = -1L;
        long free = -1L;
        long available = -1L;

        public Path() {
        }

        public Path(String path, @Nullable String mount, long total, long free, long available) {
            this.path = path;
            this.mount = mount;
            this.total = total;
            this.free = free;
            this.available = available;
        }

        public Path(StreamInput in) throws IOException {
            this.path = in.readOptionalString();
            this.mount = in.readOptionalString();
            this.type = in.readOptionalString();
            this.total = in.readLong();
            this.free = in.readLong();
            this.available = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.path);
            out.writeOptionalString(this.mount);
            out.writeOptionalString(this.type);
            out.writeLong(this.total);
            out.writeLong(this.free);
            out.writeLong(this.available);
        }

        public String getPath() {
            return this.path;
        }

        public String getMount() {
            return this.mount;
        }

        public String getType() {
            return this.type;
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getAvailable() {
            return new ByteSizeValue(this.available);
        }

        private long addLong(long current, long other) {
            if (other == -1L) {
                return current;
            }
            if (current == -1L) {
                return other;
            }
            return current + other;
        }

        public void add(Path path) {
            this.total = FsProbe.adjustForHugeFilesystems(this.addLong(this.total, path.total));
            this.free = FsProbe.adjustForHugeFilesystems(this.addLong(this.free, path.free));
            this.available = FsProbe.adjustForHugeFilesystems(this.addLong(this.available, path.available));
        }
    }

    public static class DeviceStats
    implements Writeable {
        final int majorDeviceNumber;
        final int minorDeviceNumber;
        final String deviceName;
        final long currentReadsCompleted;
        final long previousReadsCompleted;
        final long currentSectorsRead;
        final long previousSectorsRead;
        final long currentWritesCompleted;
        final long previousWritesCompleted;
        final long currentSectorsWritten;
        final long previousSectorsWritten;

        public DeviceStats(int majorDeviceNumber, int minorDeviceNumber, String deviceName, long currentReadsCompleted, long currentSectorsRead, long currentWritesCompleted, long currentSectorsWritten, DeviceStats previousDeviceStats) {
            this(majorDeviceNumber, minorDeviceNumber, deviceName, currentReadsCompleted, previousDeviceStats != null ? previousDeviceStats.currentReadsCompleted : -1L, currentSectorsWritten, previousDeviceStats != null ? previousDeviceStats.currentSectorsWritten : -1L, currentSectorsRead, previousDeviceStats != null ? previousDeviceStats.currentSectorsRead : -1L, currentWritesCompleted, previousDeviceStats != null ? previousDeviceStats.currentWritesCompleted : -1L);
        }

        private DeviceStats(int majorDeviceNumber, int minorDeviceNumber, String deviceName, long currentReadsCompleted, long previousReadsCompleted, long currentSectorsWritten, long previousSectorsWritten, long currentSectorsRead, long previousSectorsRead, long currentWritesCompleted, long previousWritesCompleted) {
            this.majorDeviceNumber = majorDeviceNumber;
            this.minorDeviceNumber = minorDeviceNumber;
            this.deviceName = deviceName;
            this.currentReadsCompleted = currentReadsCompleted;
            this.previousReadsCompleted = previousReadsCompleted;
            this.currentWritesCompleted = currentWritesCompleted;
            this.previousWritesCompleted = previousWritesCompleted;
            this.currentSectorsRead = currentSectorsRead;
            this.previousSectorsRead = previousSectorsRead;
            this.currentSectorsWritten = currentSectorsWritten;
            this.previousSectorsWritten = previousSectorsWritten;
        }

        public DeviceStats(StreamInput in) throws IOException {
            this.majorDeviceNumber = in.readVInt();
            this.minorDeviceNumber = in.readVInt();
            this.deviceName = in.readString();
            this.currentReadsCompleted = in.readLong();
            this.previousReadsCompleted = in.readLong();
            this.currentWritesCompleted = in.readLong();
            this.previousWritesCompleted = in.readLong();
            this.currentSectorsRead = in.readLong();
            this.previousSectorsRead = in.readLong();
            this.currentSectorsWritten = in.readLong();
            this.previousSectorsWritten = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.majorDeviceNumber);
            out.writeVInt(this.minorDeviceNumber);
            out.writeString(this.deviceName);
            out.writeLong(this.currentReadsCompleted);
            out.writeLong(this.previousReadsCompleted);
            out.writeLong(this.currentWritesCompleted);
            out.writeLong(this.previousWritesCompleted);
            out.writeLong(this.currentSectorsRead);
            out.writeLong(this.previousSectorsRead);
            out.writeLong(this.currentSectorsWritten);
            out.writeLong(this.previousSectorsWritten);
        }

        public long operations() {
            if (this.previousReadsCompleted == -1L || this.previousWritesCompleted == -1L) {
                return -1L;
            }
            return this.currentReadsCompleted - this.previousReadsCompleted + (this.currentWritesCompleted - this.previousWritesCompleted);
        }

        public long readOperations() {
            if (this.previousReadsCompleted == -1L) {
                return -1L;
            }
            return this.currentReadsCompleted - this.previousReadsCompleted;
        }

        public long writeOperations() {
            if (this.previousWritesCompleted == -1L) {
                return -1L;
            }
            return this.currentWritesCompleted - this.previousWritesCompleted;
        }

        public long readKilobytes() {
            if (this.previousSectorsRead == -1L) {
                return -1L;
            }
            return (this.currentSectorsRead - this.previousSectorsRead) / 2L;
        }

        public long writeKilobytes() {
            if (this.previousSectorsWritten == -1L) {
                return -1L;
            }
            return (this.currentSectorsWritten - this.previousSectorsWritten) / 2L;
        }
    }
}

