/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.transport.TransportRequest;

public class StartRecoveryRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final String targetAllocationId;
    private final DiscoveryNode sourceNode;
    private final DiscoveryNode targetNode;
    private final Store.MetadataSnapshot metadataSnapshot;
    private final boolean primaryRelocation;
    private final long startingSeqNo;

    public StartRecoveryRequest(ShardId shardId, String targetAllocationId, DiscoveryNode sourceNode, DiscoveryNode targetNode, Store.MetadataSnapshot metadataSnapshot, boolean primaryRelocation, long recoveryId, long startingSeqNo) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetAllocationId = targetAllocationId;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.metadataSnapshot = metadataSnapshot;
        this.primaryRelocation = primaryRelocation;
        this.startingSeqNo = startingSeqNo;
        assert (startingSeqNo == -2L || metadataSnapshot.getHistoryUUID() != null) : "starting seq no is set but not history uuid";
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String targetAllocationId() {
        return this.targetAllocationId;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    public boolean isPrimaryRelocation() {
        return this.primaryRelocation;
    }

    public Store.MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    public long startingSeqNo() {
        return this.startingSeqNo;
    }

    public StartRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.targetAllocationId = in.readString();
        this.sourceNode = new DiscoveryNode(in);
        this.targetNode = new DiscoveryNode(in);
        this.metadataSnapshot = new Store.MetadataSnapshot(in);
        this.primaryRelocation = in.readBoolean();
        this.startingSeqNo = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.targetAllocationId);
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        this.metadataSnapshot.writeTo(out);
        out.writeBoolean(this.primaryRelocation);
        out.writeLong(this.startingSeqNo);
    }
}

