/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private final TransportService transportService;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final TransportRequestOptions translogOpsRequestOptions;
    private final TransportRequestOptions fileChunkRequestOptions;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final Consumer<Long> onSourceThrottle;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle) {
        this.transportService = transportService;
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.onSourceThrottle = onSourceThrottle;
        this.translogOpsRequestOptions = TransportRequestOptions.builder().withCompress(true).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionLongTimeout()).build();
        this.fileChunkRequestOptions = TransportRequestOptions.builder().withCompress(false).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionTimeout()).build();
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/prepare_translog", (TransportRequest)new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, this.shardId, totalTranslogOps), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.map(listener, r -> null), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/finalize", (TransportRequest)new RecoveryFinalizeRecoveryRequest(this.recoveryId, this.shardId, globalCheckpoint, trimAboveSeqNo), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build(), new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.map(listener, r -> null), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        TransportFuture<TransportResponse.Empty> handler = new TransportFuture<TransportResponse.Empty>(EmptyTransportResponseHandler.INSTANCE_SAME);
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", (TransportRequest)new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), handler);
        handler.txGet();
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary);
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/translog_ops", (TransportRequest)request, this.translogOpsRequestOptions, new ActionListenerResponseHandler<RecoveryTranslogOperationsResponse>(ActionListener.map(listener, r -> r.localCheckpoint), RecoveryTranslogOperationsResponse::new, "generic"));
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        RecoveryFilesInfoRequest recoveryInfoFilesRequest = new RecoveryFilesInfoRequest(this.recoveryId, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/filesInfo", (TransportRequest)recoveryInfoFilesRequest, TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.map(listener, r -> null), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/clean_files", (TransportRequest)new RecoveryCleanFilesRequest(this.recoveryId, this.shardId, sourceMetadata, totalTranslogOps, globalCheckpoint), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.map(listener, r -> null), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.recoverySettings.rateLimiter();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/file_chunk", (TransportRequest)new RecoveryFileChunkRequest(this.recoveryId, this.shardId, fileMetadata, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos), this.fileChunkRequestOptions, new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.map(listener, r -> null), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }
}

