/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

class RecoveryHandoffPrimaryContextRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final ReplicationTracker.PrimaryContext primaryContext;

    RecoveryHandoffPrimaryContextRequest(long recoveryId, ShardId shardId, ReplicationTracker.PrimaryContext primaryContext) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.primaryContext = primaryContext;
    }

    long recoveryId() {
        return this.recoveryId;
    }

    ShardId shardId() {
        return this.shardId;
    }

    ReplicationTracker.PrimaryContext primaryContext() {
        return this.primaryContext;
    }

    public RecoveryHandoffPrimaryContextRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.primaryContext = new ReplicationTracker.PrimaryContext(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.primaryContext.writeTo(out);
    }

    public String toString() {
        return "RecoveryHandoffPrimaryContextRequest{recoveryId=" + this.recoveryId + ", shardId=" + this.shardId + ", primaryContext=" + this.primaryContext + "}";
    }
}

