/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.BlobRecoveryRequest;

public class BlobStartPrefixSyncRequest
extends BlobRecoveryRequest {
    private final byte prefix;
    private final ShardId shardId;

    public BlobStartPrefixSyncRequest(long recoveryId, ShardId shardId, byte prefix) {
        super(recoveryId);
        this.prefix = prefix;
        this.shardId = shardId;
    }

    public byte prefix() {
        return this.prefix;
    }

    public BlobStartPrefixSyncRequest(StreamInput in) throws IOException {
        super(in);
        this.prefix = in.readByte();
        this.shardId = new ShardId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.prefix);
        this.shardId.writeTo(out);
    }
}

