/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class BlobStartPrefixResponse
extends TransportResponse {
    public final byte[][] existingDigests;

    public BlobStartPrefixResponse(StreamInput in) throws IOException {
        int size = in.readInt();
        this.existingDigests = new byte[size][20];
        for (int i = 0; i < size; ++i) {
            in.read(this.existingDigests[i]);
        }
    }

    BlobStartPrefixResponse(byte[][] currentDigests) {
        this.existingDigests = currentDigests;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.existingDigests.length);
        for (byte[] digest : this.existingDigests) {
            out.write(digest);
        }
    }
}

