/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import io.crate.blob.v2.BlobShard;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.BlobRecoveryTransferStatus;
import org.elasticsearch.indices.recovery.RecoveryTarget;

public class BlobRecoveryStatus {
    private final RecoveryTarget recoveryTarget;
    private final ConcurrentMap<Long, BlobRecoveryTransferStatus> onGoingTransfers = new ConcurrentHashMap<Long, BlobRecoveryTransferStatus>();
    final BlobShard blobShard;

    public BlobRecoveryStatus(RecoveryTarget recoveryTarget, BlobShard blobShard) {
        this.recoveryTarget = recoveryTarget;
        this.blobShard = blobShard;
    }

    public long recoveryId() {
        return this.recoveryTarget.recoveryId();
    }

    public boolean canceled() {
        return this.recoveryTarget.cancellableThreads().isCancelled();
    }

    public void sentCanceledToSource() {
        this.recoveryTarget.cancellableThreads().checkForCancel();
    }

    public ShardId shardId() {
        return this.recoveryTarget.shardId();
    }

    public ConcurrentMap<Long, BlobRecoveryTransferStatus> onGoingTransfers() {
        return this.onGoingTransfers;
    }
}

