/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.indices.recovery.BlobRecoveryRequest;

public class BlobRecoveryDeleteRequest
extends BlobRecoveryRequest {
    public final BytesReference[] digests;

    public BlobRecoveryDeleteRequest(long recoveryId, BytesArray[] digests) {
        super(recoveryId);
        this.digests = digests;
    }

    public BlobRecoveryDeleteRequest(StreamInput in) throws IOException {
        super(in);
        this.digests = new BytesReference[in.readVInt()];
        for (int i = 0; i < this.digests.length; ++i) {
            this.digests[i] = in.readBytesReference();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.digests.length);
        for (int i = 0; i < this.digests.length; ++i) {
            out.writeBytesReference(this.digests[i]);
        }
    }
}

