/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.indices.recovery.BlobRecoveryRequest;

public class BlobRecoveryChunkRequest
extends BlobRecoveryRequest {
    private final long transferId;
    private final BytesReference content;
    private final boolean isLast;

    public BlobRecoveryChunkRequest(long requestId, long transferId, BytesArray content, boolean isLast) {
        super(requestId);
        this.transferId = transferId;
        this.content = content;
        this.isLast = isLast;
    }

    public BytesReference content() {
        return this.content;
    }

    public long transferId() {
        return this.transferId;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public BlobRecoveryChunkRequest(StreamInput in) throws IOException {
        super(in);
        this.transferId = in.readVLong();
        this.content = in.readBytesReference();
        this.isLast = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.transferId);
        out.writeBytesReference(this.content);
        out.writeBoolean(this.isLast);
    }
}

