/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.ChildMemoryCircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

public class HierarchyCircuitBreakerService
extends CircuitBreakerService {
    private static final Logger LOGGER = LogManager.getLogger(HierarchyCircuitBreakerService.class);
    private static final String CHILD_LOGGER_PREFIX = "org.elasticsearch.indices.breaker.";
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static final double PARENT_BREAKER_ESCAPE_HATCH_PERCENTAGE = 0.3;
    private final ConcurrentMap<String, CircuitBreaker> breakers = new ConcurrentHashMap<String, CircuitBreaker>();
    public static final Setting<ByteSizeValue> TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.total.limit", "95%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.fielddata.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Double> FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.fielddata.overhead", 1.03, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<CircuitBreaker.Type> FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.fielddata.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<ByteSizeValue> REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.request.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.request.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<CircuitBreaker.Type> REQUEST_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.request.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> ACCOUNTING_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.accounting.limit", "100%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> ACCOUNTING_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.accounting.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<CircuitBreaker.Type> ACCOUNTING_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.accounting.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("network.breaker.inflight_requests.limit", "100%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("network.breaker.inflight_requests.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<CircuitBreaker.Type> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("network.breaker.inflight_requests.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final String QUERY = "query";
    public static final CrateSetting<ByteSizeValue> QUERY_CIRCUIT_BREAKER_LIMIT_SETTING = CrateSetting.of(Setting.memorySizeSetting("indices.breaker.query.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<Double> QUERY_CIRCUIT_BREAKER_OVERHEAD_SETTING = CrateSetting.of(Setting.doubleSetting("indices.breaker.query.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated), DataTypes.DOUBLE);
    public static final String JOBS_LOG = "jobs_log";
    public static final CrateSetting<ByteSizeValue> JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING = CrateSetting.of(Setting.memorySizeSetting("stats.breaker.log.jobs.limit", "5%", Setting.Property.Dynamic, Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<Double> JOBS_LOG_CIRCUIT_BREAKER_OVERHEAD_SETTING = CrateSetting.of(Setting.doubleSetting("stats.breaker.log.jobs.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated), DataTypes.DOUBLE);
    public static final String OPERATIONS_LOG = "operations_log";
    public static final CrateSetting<ByteSizeValue> OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING = CrateSetting.of(Setting.memorySizeSetting("stats.breaker.log.operations.limit", "5%", Setting.Property.Dynamic, Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<Double> OPERATIONS_LOG_CIRCUIT_BREAKER_OVERHEAD_SETTING = CrateSetting.of(Setting.doubleSetting("stats.breaker.log.operations.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated), DataTypes.DOUBLE);
    public static final String BREAKING_EXCEPTION_MESSAGE = "[query] Data too large, data for [%s] would be larger than limit of [%d/%s]";
    private volatile BreakerSettings queryBreakerSettings;
    private volatile BreakerSettings logJobsBreakerSettings;
    private volatile BreakerSettings logOperationsBreakerSettings;
    private volatile BreakerSettings parentSettings;
    private volatile BreakerSettings inFlightRequestsSettings;
    private volatile BreakerSettings requestSettings;
    private volatile BreakerSettings accountingSettings;
    private final AtomicLong parentTripCount = new AtomicLong(0L);

    public HierarchyCircuitBreakerService(Settings settings, ClusterSettings clusterSettings) {
        this.inFlightRequestsSettings = new BreakerSettings("in_flight_requests", IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_TYPE_SETTING.get(settings));
        this.requestSettings = new BreakerSettings("request", REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), REQUEST_CIRCUIT_BREAKER_TYPE_SETTING.get(settings));
        this.accountingSettings = new BreakerSettings("accounting", ACCOUNTING_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), ACCOUNTING_CIRCUIT_BREAKER_TYPE_SETTING.get(settings));
        this.parentSettings = new BreakerSettings("parent", TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), CircuitBreaker.Type.PARENT);
        this.queryBreakerSettings = new BreakerSettings(QUERY, QUERY_CIRCUIT_BREAKER_LIMIT_SETTING.setting().get(settings).getBytes(), CircuitBreaker.Type.MEMORY);
        this.logJobsBreakerSettings = new BreakerSettings(JOBS_LOG, JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING.setting().get(settings).getBytes(), CircuitBreaker.Type.MEMORY);
        this.logOperationsBreakerSettings = new BreakerSettings(OPERATIONS_LOG, OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING.setting().get(settings).getBytes(), CircuitBreaker.Type.MEMORY);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("parent circuit breaker with settings {}", (Object)this.parentSettings);
        }
        this.registerBreaker(this.requestSettings);
        this.registerBreaker(this.inFlightRequestsSettings);
        this.registerBreaker(this.accountingSettings);
        this.registerBreaker(this.queryBreakerSettings);
        this.registerBreaker(this.logJobsBreakerSettings);
        this.registerBreaker(this.logOperationsBreakerSettings);
        clusterSettings.addSettingsUpdateConsumer(TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, this::setTotalCircuitBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING, this::setInFlightRequestsBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, this::setRequestBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(ACCOUNTING_CIRCUIT_BREAKER_LIMIT_SETTING, this::setAccountingBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(QUERY_CIRCUIT_BREAKER_LIMIT_SETTING.setting(), newLimit -> this.setBreakerLimit(this.queryBreakerSettings, QUERY, s -> {
            this.queryBreakerSettings = s;
        }, (ByteSizeValue)newLimit));
        clusterSettings.addSettingsUpdateConsumer(JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING.setting(), newLimit -> this.setBreakerLimit(this.logJobsBreakerSettings, JOBS_LOG, s -> {
            this.logJobsBreakerSettings = s;
        }, (ByteSizeValue)newLimit));
        clusterSettings.addSettingsUpdateConsumer(OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING.setting(), newLimit -> this.setBreakerLimit(this.logOperationsBreakerSettings, OPERATIONS_LOG, s -> {
            this.logOperationsBreakerSettings = s;
        }, (ByteSizeValue)newLimit));
    }

    public static String breakingExceptionMessage(String label, long limit) {
        return String.format(Locale.ENGLISH, BREAKING_EXCEPTION_MESSAGE, label, limit, new ByteSizeValue(limit));
    }

    private void setRequestBreakerLimit(ByteSizeValue newRequestMax) {
        BreakerSettings newRequestSettings = new BreakerSettings("request", newRequestMax.getBytes(), this.requestSettings.getType());
        this.registerBreaker(newRequestSettings);
        this.requestSettings = newRequestSettings;
        LOGGER.info("Updated breaker settings request: {}", (Object)newRequestSettings);
    }

    private void setInFlightRequestsBreakerLimit(ByteSizeValue newInFlightRequestsMax) {
        BreakerSettings newInFlightRequestsSettings = new BreakerSettings("in_flight_requests", newInFlightRequestsMax.getBytes(), this.inFlightRequestsSettings.getType());
        this.registerBreaker(newInFlightRequestsSettings);
        this.inFlightRequestsSettings = newInFlightRequestsSettings;
        LOGGER.info("Updated breaker settings for in-flight requests: {}", (Object)newInFlightRequestsSettings);
    }

    private void setAccountingBreakerLimit(ByteSizeValue newAccountingMax) {
        BreakerSettings newAccountingSettings = new BreakerSettings("accounting", newAccountingMax.getBytes(), this.inFlightRequestsSettings.getType());
        this.registerBreaker(newAccountingSettings);
        this.accountingSettings = newAccountingSettings;
        LOGGER.info("Updated breaker settings for accounting requests: {}", (Object)newAccountingSettings);
    }

    private void setTotalCircuitBreakerLimit(ByteSizeValue byteSizeValue) {
        BreakerSettings newParentSettings;
        this.parentSettings = newParentSettings = new BreakerSettings("parent", byteSizeValue.getBytes(), CircuitBreaker.Type.PARENT);
    }

    private void setBreakerLimit(BreakerSettings oldSettings, String breakerName, Consumer<BreakerSettings> settingsConsumer, ByteSizeValue newLimit) {
        long newLimitBytes = newLimit == null ? oldSettings.getLimit() : newLimit.getBytes();
        BreakerSettings newSettings = new BreakerSettings(breakerName, newLimitBytes, oldSettings.getType());
        this.registerBreaker(newSettings);
        settingsConsumer.accept(newSettings);
        LOGGER.info("[{}] Updated breaker settings: {}", (Object)breakerName, (Object)newSettings);
    }

    @Override
    public CircuitBreaker getBreaker(String name) {
        return (CircuitBreaker)this.breakers.get(name);
    }

    @Override
    public CircuitBreakerStats stats(String name) {
        if ("parent".equals(name)) {
            return new CircuitBreakerStats("parent", this.parentSettings.getLimit(), this.parentUsed(0L), this.parentTripCount.get(), 1.0);
        }
        CircuitBreaker breaker = Objects.requireNonNull((CircuitBreaker)this.breakers.get(name), "Unknown circuit breaker: " + name);
        return new CircuitBreakerStats(breaker.getName(), breaker.getLimit(), breaker.getUsed(), breaker.getTrippedCount(), 1.0);
    }

    private long parentUsed(long newBytesReserved) {
        return this.currentMemoryUsage() + newBytesReserved;
    }

    long currentMemoryUsage() {
        try {
            return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
        }
        catch (IllegalArgumentException ex) {
            assert (ex.getMessage().matches("committed = \\d+ should be < max = \\d+"));
            LOGGER.info("Cannot determine current memory usage due to JDK-8207200.", (Throwable)ex);
            return 0L;
        }
    }

    @Override
    public void checkParentLimit(long newBytesReserved, String label) throws CircuitBreakingException {
        long parentLimit;
        long totalUsed = this.parentUsed(newBytesReserved);
        if (totalUsed > (parentLimit = this.parentSettings.getLimit())) {
            long breakersTotalUsed = this.breakers.values().stream().mapToLong(CircuitBreaker::getUsed).sum();
            if ((double)(breakersTotalUsed + newBytesReserved) < (double)parentLimit * 0.3) {
                return;
            }
            this.parentTripCount.incrementAndGet();
            StringBuilder message = new StringBuilder("[parent] Data too large, data for [" + label + "] would be [" + totalUsed + "/" + new ByteSizeValue(totalUsed) + "], which is larger than the limit of [" + parentLimit + "/" + new ByteSizeValue(parentLimit) + "]");
            message.append(", usages [");
            message.append(this.breakers.entrySet().stream().map(e -> {
                CircuitBreaker breaker = (CircuitBreaker)e.getValue();
                long breakerUsed = breaker.getUsed();
                return (String)e.getKey() + "=" + breakerUsed + "/" + new ByteSizeValue(breakerUsed);
            }).collect(Collectors.joining(", ")));
            message.append("]");
            throw new CircuitBreakingException(message.toString(), totalUsed, parentLimit);
        }
    }

    @Override
    public void registerBreaker(BreakerSettings breakerSettings) {
        if (breakerSettings.getType() != CircuitBreaker.Type.NOOP) {
            CircuitBreaker oldBreaker;
            ChildMemoryCircuitBreaker breaker = new ChildMemoryCircuitBreaker(breakerSettings, LogManager.getLogger((String)(CHILD_LOGGER_PREFIX + breakerSettings.getName())), this);
            do {
                if ((oldBreaker = this.breakers.putIfAbsent(breakerSettings.getName(), breaker)) == null) {
                    return;
                }
                breaker = new ChildMemoryCircuitBreaker(breakerSettings, (ChildMemoryCircuitBreaker)oldBreaker, LogManager.getLogger((String)(CHILD_LOGGER_PREFIX + breakerSettings.getName())), this);
            } while (!this.breakers.replace(breakerSettings.getName(), oldBreaker, breaker));
            return;
        }
        NoopCircuitBreaker breaker = new NoopCircuitBreaker(breakerSettings.getName());
        this.breakers.put(breakerSettings.getName(), breaker);
    }
}

