/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.beans.ConstructorProperties;
import org.elasticsearch.common.unit.ByteSizeValue;

public class CircuitBreakerStats {
    private final String name;
    private final long limit;
    private final long used;
    private final long trippedCount;
    private final double overhead;

    @ConstructorProperties(value={"name", "limit", "used", "trippedCount", "overhead"})
    public CircuitBreakerStats(String name, long limit, long used, long trippedCount, double overhead) {
        this.name = name;
        this.limit = limit;
        this.used = used;
        this.trippedCount = trippedCount;
        this.overhead = overhead;
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getUsed() {
        return this.used;
    }

    public long getTrippedCount() {
        return this.trippedCount;
    }

    @Deprecated
    public double getOverhead() {
        return this.overhead;
    }

    public String toString() {
        return "[" + this.name + ",limit=" + this.limit + "/" + new ByteSizeValue(this.limit) + ",estimated=" + this.used + "/" + new ByteSizeValue(this.used) + ",overhead=" + this.overhead + ",tripped=" + this.trippedCount + "]";
    }
}

