/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class ShardLimitValidator {
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_NODE = Setting.intSetting("cluster.max_shards_per_node", 1000, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    protected final AtomicInteger shardLimitPerNode = new AtomicInteger();

    public ShardLimitValidator(Settings settings, ClusterService clusterService) {
        this.shardLimitPerNode.set(SETTING_CLUSTER_MAX_SHARDS_PER_NODE.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_NODE, this::setShardLimitPerNode);
    }

    private void setShardLimitPerNode(int newValue) {
        this.shardLimitPerNode.set(newValue);
    }

    public int getShardLimitPerNode() {
        return this.shardLimitPerNode.get();
    }

    public void validateShardLimit(Settings settings, ClusterState state) {
        int numberOfReplicas;
        int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings).intValue()));
        Optional<String> shardLimit = this.checkShardLimit(shardsToCreate, state);
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    public Optional<String> checkShardLimit(int newShards, ClusterState state) {
        return ShardLimitValidator.checkShardLimit(newShards, state, this.getShardLimitPerNode());
    }

    static Optional<String> checkShardLimit(int newShards, ClusterState state, int maxShardsPerNodeSetting) {
        int nodeCount = state.getNodes().getDataNodes().size();
        if (nodeCount == 0 || newShards < 0) {
            return Optional.empty();
        }
        int maxShardsPerNode = maxShardsPerNodeSetting;
        int maxShardsInCluster = maxShardsPerNode * nodeCount;
        int currentOpenShards = state.getMetadata().getTotalOpenIndexShards();
        if (currentOpenShards + newShards > maxShardsInCluster) {
            String errorMessage = "this action would add [" + newShards + "] total shards, but this cluster currently has [" + currentOpenShards + "]/[" + maxShardsInCluster + "] maximum shards open";
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }
}

