/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

public class TranslogStats {
    private final long translogSizeInBytes;
    private final int numberOfOperations;
    private final long uncommittedSizeInBytes;
    private final int uncommittedOperations;

    public TranslogStats(int numberOfOperations, long translogSizeInBytes, int uncommittedOperations, long uncommittedSizeInBytes) {
        if (numberOfOperations < 0) {
            throw new IllegalArgumentException("numberOfOperations must be >= 0");
        }
        if (translogSizeInBytes < 0L) {
            throw new IllegalArgumentException("translogSizeInBytes must be >= 0");
        }
        if (uncommittedOperations < 0) {
            throw new IllegalArgumentException("uncommittedOperations must be >= 0");
        }
        if (uncommittedSizeInBytes < 0L) {
            throw new IllegalArgumentException("uncommittedSizeInBytes must be >= 0");
        }
        this.numberOfOperations = numberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
        this.uncommittedSizeInBytes = uncommittedSizeInBytes;
        this.uncommittedOperations = uncommittedOperations;
    }

    public long getTranslogSizeInBytes() {
        return this.translogSizeInBytes;
    }

    public int estimatedNumberOfOperations() {
        return this.numberOfOperations;
    }

    public long getUncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    public int getUncommittedOperations() {
        return this.uncommittedOperations;
    }

    public String toString() {
        return "TranslogStats{translogSizeInBytes=" + this.translogSizeInBytes + ", numberOfOperations=" + this.numberOfOperations + ", uncommittedSizeInBytes=" + this.uncommittedSizeInBytes + ", uncommittedOperations=" + this.uncommittedOperations + "}";
    }
}

