/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class StoreStats
implements Writeable,
ToXContentFragment {
    private long sizeInBytes;

    public StoreStats() {
    }

    public StoreStats(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public StoreStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getSize() {
        return this.size();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("store");
        builder.humanReadableField("size_in_bytes", "size", this.size());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String STORE = "store";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";

        Fields() {
        }
    }
}

