/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import io.crate.common.unit.TimeValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.lucene.store.FilterIndexOutput;
import org.elasticsearch.common.util.SingleObjectCache;

final class ByteSizeCachingDirectory
extends FilterDirectory {
    private final SingleObjectCache<SizeAndModCount> size;
    private long modCount = 0L;
    private long numOpenOutputs = 0L;

    private static long estimateSizeInBytes(Directory directory) throws IOException {
        String[] files;
        long estimatedSize = 0L;
        for (String file : files = directory.listAll()) {
            try {
                estimatedSize += directory.fileLength(file);
            }
            catch (FileNotFoundException | AccessDeniedException | NoSuchFileException iOException) {
                // empty catch block
            }
        }
        return estimatedSize;
    }

    ByteSizeCachingDirectory(Directory in, TimeValue refreshInterval) {
        super(in);
        this.size = new SingleObjectCache<SizeAndModCount>(refreshInterval, new SizeAndModCount(0L, -1L, true)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected SizeAndModCount refresh() {
                long size;
                boolean pendingWrite;
                long modCount;
                ByteSizeCachingDirectory byteSizeCachingDirectory = ByteSizeCachingDirectory.this;
                synchronized (byteSizeCachingDirectory) {
                    modCount = ByteSizeCachingDirectory.this.modCount;
                    pendingWrite = ByteSizeCachingDirectory.this.numOpenOutputs != 0L;
                }
                try {
                    size = ByteSizeCachingDirectory.estimateSizeInBytes(ByteSizeCachingDirectory.this.getDelegate());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return new SizeAndModCount(size, modCount, pendingWrite);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean needsRefresh() {
                if (!super.needsRefresh()) {
                    return false;
                }
                SizeAndModCount cached = (SizeAndModCount)this.getNoRefresh();
                if (cached.pendingWrite) {
                    return true;
                }
                ByteSizeCachingDirectory byteSizeCachingDirectory = ByteSizeCachingDirectory.this;
                synchronized (byteSizeCachingDirectory) {
                    return ByteSizeCachingDirectory.this.numOpenOutputs != 0L || cached.modCount != ByteSizeCachingDirectory.this.modCount;
                }
            }
        };
    }

    long estimateSizeInBytes() throws IOException {
        try {
            return this.size.getOrRefresh().size;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.wrapIndexOutput(super.createOutput(name, context));
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        return this.wrapIndexOutput(super.createTempOutput(prefix, suffix, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexOutput wrapIndexOutput(IndexOutput out) {
        ByteSizeCachingDirectory byteSizeCachingDirectory = this;
        synchronized (byteSizeCachingDirectory) {
            ++this.numOpenOutputs;
        }
        return new FilterIndexOutput(out.toString(), out){

            public void writeBytes(byte[] b, int length) throws IOException {
                super.writeBytes(b, length);
            }

            @Override
            public void writeByte(byte b) throws IOException {
                super.writeByte(b);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        --ByteSizeCachingDirectory.this.numOpenOutputs;
                        ++ByteSizeCachingDirectory.this.modCount;
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String name) throws IOException {
        try {
            super.deleteFile(name);
        }
        finally {
            ByteSizeCachingDirectory byteSizeCachingDirectory = this;
            synchronized (byteSizeCachingDirectory) {
                ++this.modCount;
            }
        }
    }

    private static class SizeAndModCount {
        final long size;
        final long modCount;
        final boolean pendingWrite;

        SizeAndModCount(long length, long modCount, boolean pendingWrite) {
            this.size = length;
            this.modCount = modCount;
            this.pendingWrite = pendingWrite;
        }
    }
}

