/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.index.mapper.Uid;

final class ShardSplittingQuery
extends Query {
    private final IndexMetadata indexMetadata;
    private final int shardId;

    ShardSplittingQuery(IndexMetadata indexMetadata, int shardId) {
        this.indexMetadata = indexMetadata;
        this.shardId = shardId;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(delete docs query)";
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader leafReader = context.reader();
                FixedBitSet bitSet = new FixedBitSet(leafReader.maxDoc());
                Terms terms = leafReader.terms("_routing");
                Predicate<BytesRef> includeInShard = ref -> {
                    int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, Uid.decodeId(ref.bytes, ref.offset, ref.length), null);
                    return ShardSplittingQuery.this.shardId == targetShardId;
                };
                if (terms == null) {
                    assert (!ShardSplittingQuery.this.indexMetadata.isRoutingPartitionedIndex());
                    ShardSplittingQuery.findSplitDocs("_id", includeInShard, leafReader, arg_0 -> ((FixedBitSet)bitSet).set(arg_0));
                } else {
                    if (ShardSplittingQuery.this.indexMetadata.isRoutingPartitionedIndex()) {
                        Visitor visitor = new Visitor(leafReader);
                        RoutingPartitionedDocIdSetIterator twoPhaseIterator = new RoutingPartitionedDocIdSetIterator(visitor);
                        return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, (TwoPhaseIterator)twoPhaseIterator);
                    }
                    ShardSplittingQuery.findSplitDocs("_routing", ref -> {
                        int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, null, ref.utf8ToString());
                        return ShardSplittingQuery.this.shardId == targetShardId;
                    }, leafReader, arg_0 -> ((FixedBitSet)bitSet).set(arg_0));
                    if (terms.getDocCount() != leafReader.maxDoc()) {
                        FixedBitSet hasRoutingValue = new FixedBitSet(leafReader.maxDoc());
                        ShardSplittingQuery.findSplitDocs("_routing", ref -> false, leafReader, arg_0 -> ((FixedBitSet)hasRoutingValue).set(arg_0));
                        IntConsumer bitSetConsumer = arg_0 -> ((FixedBitSet)bitSet).set(arg_0);
                        ShardSplittingQuery.findSplitDocs("_id", includeInShard, leafReader, docId -> {
                            if (!hasRoutingValue.get(docId)) {
                                bitSetConsumer.accept(docId);
                            }
                        });
                    }
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, (DocIdSetIterator)new BitSetIterator((BitSet)bitSet, (long)bitSet.length()));
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    public String toString(String field) {
        return "shard_splitting_query";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShardSplittingQuery that = (ShardSplittingQuery)((Object)o);
        if (this.shardId != that.shardId) {
            return false;
        }
        return this.indexMetadata.equals(that.indexMetadata);
    }

    public int hashCode() {
        int result = this.indexMetadata.hashCode();
        result = 31 * result + this.shardId;
        return this.classHash() ^ result;
    }

    private static void findSplitDocs(String idField, Predicate<BytesRef> includeInShard, LeafReader leafReader, IntConsumer consumer) throws IOException {
        BytesRef idTerm;
        Terms terms = leafReader.terms(idField);
        TermsEnum iterator = terms.iterator();
        PostingsEnum postingsEnum = null;
        while ((idTerm = iterator.next()) != null) {
            int doc;
            if (includeInShard.test(idTerm)) continue;
            postingsEnum = iterator.postings(postingsEnum);
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                consumer.accept(doc);
            }
        }
    }

    private static final class RoutingPartitionedDocIdSetIterator
    extends TwoPhaseIterator {
        private final Visitor visitor;

        RoutingPartitionedDocIdSetIterator(Visitor visitor) {
            super(DocIdSetIterator.all((int)visitor.leafReader.maxDoc()));
            this.visitor = visitor;
        }

        public boolean matches() throws IOException {
            return this.visitor.matches(this.approximation.docID());
        }

        public float matchCost() {
            return 42.0f;
        }
    }

    private final class Visitor
    extends StoredFieldVisitor {
        final LeafReader leafReader;
        private int leftToVisit = 2;
        private final BytesRef spare = new BytesRef();
        private String routing;
        private String id;

        Visitor(LeafReader leafReader) {
            this.leafReader = leafReader;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            switch (fieldInfo.name) {
                case "_id": {
                    this.id = Uid.decodeId(value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field: " + fieldInfo.name);
                }
            }
        }

        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.spare.bytes = value;
            this.spare.offset = 0;
            this.spare.length = value.length;
            switch (fieldInfo.name) {
                case "_routing": {
                    this.routing = this.spare.utf8ToString();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field: " + fieldInfo.name);
                }
            }
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            switch (fieldInfo.name) {
                case "_id": 
                case "_routing": {
                    --this.leftToVisit;
                    return StoredFieldVisitor.Status.YES;
                }
            }
            return this.leftToVisit == 0 ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
        }

        boolean matches(int doc) throws IOException {
            this.id = null;
            this.routing = null;
            this.leftToVisit = 2;
            this.leafReader.document(doc, (StoredFieldVisitor)this);
            assert (this.id != null) : "docID must not be null - we might have hit a nested document";
            int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, this.id, this.routing);
            return targetShardId != ShardSplittingQuery.this.shardId;
        }
    }
}

