/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.Index;

public class ShardId
implements Writeable,
Comparable<ShardId> {
    private final Index index;
    private final int shardId;
    private final int hashCode;

    public ShardId(Index index, int shardId) {
        this.index = index;
        this.shardId = shardId;
        this.hashCode = this.computeHashCode();
    }

    public ShardId(String index, String indexUUID, int shardId) {
        this(new Index(index, indexUUID), shardId);
    }

    public ShardId(StreamInput in) throws IOException {
        this.index = new Index(in);
        this.shardId = in.readVInt();
        this.hashCode = this.computeHashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shardId);
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexName() {
        return this.index.getName();
    }

    public int id() {
        return this.shardId;
    }

    public int getId() {
        return this.id();
    }

    public String toString() {
        return "[" + this.index.getName() + "][" + this.shardId + "]";
    }

    public static ShardId fromString(String shardIdString) {
        int splitPosition = shardIdString.indexOf("][");
        if (splitPosition <= 0 || shardIdString.charAt(0) != '[' || shardIdString.charAt(shardIdString.length() - 1) != ']') {
            throw new IllegalArgumentException("Unexpected shardId string format, expected [indexName][shardId] but got " + shardIdString);
        }
        String indexName = shardIdString.substring(1, splitPosition);
        int shardId = Integer.parseInt(shardIdString.substring(splitPosition + 2, shardIdString.length() - 1));
        return new ShardId(new Index(indexName, "_na_"), shardId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardId shardId1 = (ShardId)o;
        return this.shardId == shardId1.shardId && this.index.equals(shardId1.index);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + this.shardId;
        return result;
    }

    @Override
    public int compareTo(ShardId o) {
        if (o.getId() == this.shardId) {
            int compare = this.index.getName().compareTo(o.getIndex().getName());
            if (compare != 0) {
                return compare;
            }
            return this.index.getUUID().compareTo(o.getIndex().getUUID());
        }
        return Integer.compare(this.shardId, o.getId());
    }
}

