/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import io.crate.common.io.IOUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class PrimaryReplicaSyncer {
    private static final Logger LOGGER = LogManager.getLogger(PrimaryReplicaSyncer.class);
    private final TaskManager taskManager;
    private final SyncAction syncAction;
    public static final ByteSizeValue DEFAULT_CHUNK_SIZE = new ByteSizeValue(512L, ByteSizeUnit.KB);
    private volatile ByteSizeValue chunkSize = DEFAULT_CHUNK_SIZE;

    @Inject
    public PrimaryReplicaSyncer(TransportService transportService, TransportResyncReplicationAction syncAction) {
        this(transportService.getTaskManager(), (SyncAction)syncAction);
    }

    public PrimaryReplicaSyncer(TaskManager taskManager, SyncAction syncAction) {
        this.taskManager = taskManager;
        this.syncAction = syncAction;
    }

    void setChunkSize(ByteSizeValue chunkSize) {
        if (chunkSize.bytesAsInt() <= 0) {
            throw new IllegalArgumentException("chunkSize must be > 0");
        }
        this.chunkSize = chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resync(final IndexShard indexShard, final ActionListener<ResyncTask> listener) {
        Translog.Snapshot snapshot = null;
        try {
            long startingSeqNo = indexShard.getLastKnownGlobalCheckpoint() + 1L;
            long maxSeqNo = indexShard.seqNoStats().getMaxSeqNo();
            final ShardId shardId = indexShard.shardId();
            final Translog.Snapshot originalSnapshot = snapshot = indexShard.getHistoryOperations("resync", startingSeqNo);
            final Translog.Snapshot wrappedSnapshot = new Translog.Snapshot(){

                @Override
                public synchronized void close() throws IOException {
                    originalSnapshot.close();
                }

                @Override
                public synchronized int totalOperations() {
                    return originalSnapshot.totalOperations();
                }

                @Override
                public synchronized Translog.Operation next() throws IOException {
                    IndexShardState state = indexShard.state();
                    if (state == IndexShardState.CLOSED) {
                        throw new IndexShardClosedException(shardId);
                    }
                    assert (state == IndexShardState.STARTED) : "resync should only happen on a started shard, but state was: " + state;
                    return originalSnapshot.next();
                }
            };
            ActionListener<ResyncTask> resyncListener = new ActionListener<ResyncTask>(){

                @Override
                public void onResponse(ResyncTask resyncTask) {
                    try {
                        wrappedSnapshot.close();
                        listener.onResponse(resyncTask);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        wrappedSnapshot.close();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    finally {
                        listener.onFailure(e);
                    }
                }
            };
            long maxSeenAutoIdTimestamp = indexShard.getMaxSeenAutoIdTimestamp();
            this.resync(shardId, indexShard.routingEntry().allocationId().getId(), indexShard.getPendingPrimaryTerm(), wrappedSnapshot, startingSeqNo, maxSeqNo, maxSeenAutoIdTimestamp, resyncListener);
        }
        catch (Exception e) {
            try {
                IOUtils.close(snapshot);
            }
            catch (IOException inner) {
                e.addSuppressed(inner);
            }
            finally {
                listener.onFailure(e);
            }
        }
    }

    private void resync(ShardId shardId, String primaryAllocationId, long primaryTerm, Translog.Snapshot snapshot, long startingSeqNo, long maxSeqNo, long maxSeenAutoIdTimestamp, final ActionListener<ResyncTask> listener) {
        ResyncRequest request = new ResyncRequest(shardId, primaryAllocationId);
        final ResyncTask resyncTask = (ResyncTask)this.taskManager.register("transport", "resync", request);
        ActionListener<Void> wrappedListener = new ActionListener<Void>(){

            @Override
            public void onResponse(Void ignore) {
                resyncTask.setPhase("finished");
                PrimaryReplicaSyncer.this.taskManager.unregister(resyncTask);
                listener.onResponse(resyncTask);
            }

            @Override
            public void onFailure(Exception e) {
                resyncTask.setPhase("finished");
                PrimaryReplicaSyncer.this.taskManager.unregister(resyncTask);
                listener.onFailure(e);
            }
        };
        try {
            new SnapshotSender(this.syncAction, resyncTask, shardId, primaryAllocationId, primaryTerm, snapshot, this.chunkSize.bytesAsInt(), startingSeqNo, maxSeqNo, maxSeenAutoIdTimestamp, wrappedListener).run();
        }
        catch (Exception e) {
            wrappedListener.onFailure(e);
        }
    }

    public static interface SyncAction {
        public void sync(ResyncReplicationRequest var1, Task var2, String var3, long var4, ActionListener<ReplicationResponse> var6);
    }

    public static class ResyncRequest
    extends TransportRequest {
        private final ShardId shardId;
        private final String allocationId;

        public ResyncRequest(ShardId shardId, String allocationId) {
            this.shardId = shardId;
            this.allocationId = allocationId;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId) {
            return new ResyncTask(id, type, action, this.getDescription(), parentTaskId);
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "ResyncRequest{ " + this.shardId + ", " + this.allocationId + " }";
        }
    }

    public static class ResyncTask
    extends Task {
        private volatile String phase = "starting";
        private volatile int totalOperations;
        private volatile int resyncedOperations;
        private volatile int skippedOperations;

        public ResyncTask(long id, String type, String action, String description, TaskId parentTaskId) {
            super(id, type, action, description, parentTaskId);
        }

        public void setPhase(String phase) {
            this.phase = phase;
        }

        public String getPhase() {
            return this.phase;
        }

        public int getTotalOperations() {
            return this.totalOperations;
        }

        public void setTotalOperations(int totalOperations) {
            this.totalOperations = totalOperations;
        }

        public int getResyncedOperations() {
            return this.resyncedOperations;
        }

        public void setResyncedOperations(int resyncedOperations) {
            this.resyncedOperations = resyncedOperations;
        }

        public int getSkippedOperations() {
            return this.skippedOperations;
        }

        public void setSkippedOperations(int skippedOperations) {
            this.skippedOperations = skippedOperations;
        }
    }

    static class SnapshotSender
    extends AbstractRunnable
    implements ActionListener<ReplicationResponse> {
        private final SyncAction syncAction;
        private final ResyncTask task;
        private final String primaryAllocationId;
        private final long primaryTerm;
        private final ShardId shardId;
        private final Translog.Snapshot snapshot;
        private final long startingSeqNo;
        private final long maxSeqNo;
        private final long maxSeenAutoIdTimestamp;
        private final int chunkSizeInBytes;
        private final ActionListener<Void> listener;
        private final AtomicBoolean firstMessage = new AtomicBoolean(true);
        private final AtomicInteger totalSentOps = new AtomicInteger();
        private final AtomicInteger totalSkippedOps = new AtomicInteger();
        private final AtomicBoolean closed = new AtomicBoolean();
        private static final Translog.Operation[] EMPTY_ARRAY = new Translog.Operation[0];

        SnapshotSender(SyncAction syncAction, ResyncTask task, ShardId shardId, String primaryAllocationId, long primaryTerm, Translog.Snapshot snapshot, int chunkSizeInBytes, long startingSeqNo, long maxSeqNo, long maxSeenAutoIdTimestamp, ActionListener<Void> listener) {
            this.syncAction = syncAction;
            this.task = task;
            this.shardId = shardId;
            this.primaryAllocationId = primaryAllocationId;
            this.primaryTerm = primaryTerm;
            this.snapshot = snapshot;
            this.chunkSizeInBytes = chunkSizeInBytes;
            this.startingSeqNo = startingSeqNo;
            this.maxSeqNo = maxSeqNo;
            this.maxSeenAutoIdTimestamp = maxSeenAutoIdTimestamp;
            this.listener = listener;
            task.setTotalOperations(snapshot.totalOperations());
        }

        @Override
        public void onResponse(ReplicationResponse response) {
            this.run();
        }

        @Override
        public void onFailure(Exception e) {
            if (this.closed.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            }
        }

        @Override
        protected void doRun() throws Exception {
            long trimmedAboveSeqNo;
            Translog.Operation operation;
            long size = 0L;
            ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
            this.task.setPhase("collecting_ops");
            this.task.setResyncedOperations(this.totalSentOps.get());
            this.task.setSkippedOperations(this.totalSkippedOps.get());
            while ((operation = this.snapshot.next()) != null) {
                long seqNo = operation.seqNo();
                if (seqNo == -2L || seqNo < this.startingSeqNo) {
                    this.totalSkippedOps.incrementAndGet();
                    continue;
                }
                assert (operation.seqNo() >= 0L) : "sending operation with unassigned sequence number [" + operation + "]";
                operations.add(operation);
                this.totalSentOps.incrementAndGet();
                if ((size += operation.estimateSize()) < (long)this.chunkSizeInBytes) continue;
                break;
            }
            long l = trimmedAboveSeqNo = this.firstMessage.get() ? this.maxSeqNo : -2L;
            if (!operations.isEmpty() || trimmedAboveSeqNo != -2L) {
                this.task.setPhase("sending_ops");
                ResyncReplicationRequest request = new ResyncReplicationRequest(this.shardId, trimmedAboveSeqNo, this.maxSeenAutoIdTimestamp, operations.toArray(EMPTY_ARRAY));
                LOGGER.trace("{} sending batch of [{}][{}] (total sent: [{}], skipped: [{}])", (Object)this.shardId, (Object)operations.size(), (Object)new ByteSizeValue(size), (Object)this.totalSentOps.get(), (Object)this.totalSkippedOps.get());
                this.firstMessage.set(false);
                this.syncAction.sync(request, this.task, this.primaryAllocationId, this.primaryTerm, this);
            } else if (this.closed.compareAndSet(false, true)) {
                LOGGER.trace("{} resync completed (total sent: [{}], skipped: [{}])", (Object)this.shardId, (Object)this.totalSentOps.get(), (Object)this.totalSkippedOps.get());
                this.listener.onResponse(null);
            }
        }
    }
}

