/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryShardException;

public class QueryShardContext {
    private final MapperService mapperService;
    private final Index fullyQualifiedIndex;
    private boolean allowUnmappedFields;

    public QueryShardContext(IndexSettings indexSettings, MapperService mapperService) {
        this.mapperService = mapperService;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.fullyQualifiedIndex = indexSettings.getIndex();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        return this.mapperService.simpleMatchToFullName(pattern);
    }

    public MappedFieldType fieldMapper(String name) {
        return this.failIfFieldMappingNotFound(name, this.mapperService.fullName(name));
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService.getObjectMapper(name);
    }

    public Analyzer getSearchAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchAnalyzer() != null) {
            return fieldType.searchAnalyzer();
        }
        return this.getMapperService().searchAnalyzer();
    }

    public Analyzer getSearchQuoteAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchQuoteAnalyzer() != null) {
            return fieldType.searchQuoteAnalyzer();
        }
        return this.getMapperService().searchQuoteAnalyzer();
    }

    private MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public MapperService getMapperService() {
        return this.mapperService;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }
}

