/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Locale;
import org.apache.lucene.search.BooleanClause;
import org.elasticsearch.common.util.CollectionUtils;

public enum Operator {
    OR,
    AND;


    public BooleanClause.Occur toBooleanClauseOccur() {
        switch (this) {
            case OR: {
                return BooleanClause.Occur.SHOULD;
            }
            case AND: {
                return BooleanClause.Occur.MUST;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public static Operator fromString(String op) {
        return Operator.valueOf(op.toUpperCase(Locale.ROOT));
    }

    private static IllegalArgumentException newOperatorException(String op) {
        return new IllegalArgumentException("operator needs to be either " + CollectionUtils.arrayAsArrayList(Operator.values()) + ", but not [" + op + "]");
    }
}

