/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.index.search.MatchQuery;

public enum MultiMatchQueryType {
    BEST_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, new ParseField("best_fields", "boolean")),
    MOST_FIELDS(MatchQuery.Type.BOOLEAN, 1.0f, new ParseField("most_fields", new String[0])),
    CROSS_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, new ParseField("cross_fields", new String[0])),
    PHRASE(MatchQuery.Type.PHRASE, 0.0f, new ParseField("phrase", new String[0])),
    PHRASE_PREFIX(MatchQuery.Type.PHRASE_PREFIX, 0.0f, new ParseField("phrase_prefix", new String[0]));

    private MatchQuery.Type matchQueryType;
    private final float tieBreaker;
    private final ParseField parseField;

    private MultiMatchQueryType(MatchQuery.Type matchQueryType, float tieBreaker, ParseField parseField) {
        this.matchQueryType = matchQueryType;
        this.tieBreaker = tieBreaker;
        this.parseField = parseField;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    public MatchQuery.Type matchQueryType() {
        return this.matchQueryType;
    }

    public ParseField parseField() {
        return this.parseField;
    }

    public static MultiMatchQueryType parse(String value, DeprecationHandler deprecationHandler) {
        MultiMatchQueryType[] values = MultiMatchQueryType.values();
        MultiMatchQueryType type = null;
        for (MultiMatchQueryType t : values) {
            if (!t.parseField().match(value, deprecationHandler)) continue;
            type = t;
            break;
        }
        if (type == null) {
            throw new ElasticsearchParseException("failed to parse [multi_match] query type [{}]. unknown type.", value);
        }
        return type;
    }
}

