/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class ExistsQueryBuilder {
    public static final String NAME = "exists";

    public static Query newFilter(QueryShardContext context, String fieldPattern) {
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getMapperService().fullName("_field_names");
        if (fieldNamesFieldType == null) {
            return Queries.newMatchNoDocsQuery("Missing types in \"exists\" query.");
        }
        Collection<String> fields = context.getObjectMapper(fieldPattern) != null ? Collections.singleton(fieldPattern) : context.simpleMatchToIndexNames(fieldPattern);
        if (fields.size() == 1) {
            String field = fields.iterator().next();
            return ExistsQueryBuilder.newFieldExistsQuery(context, field);
        }
        BooleanQuery.Builder boolFilterBuilder = new BooleanQuery.Builder();
        for (String field : fields) {
            boolFilterBuilder.add(ExistsQueryBuilder.newFieldExistsQuery(context, field), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)boolFilterBuilder.build());
    }

    private static Query newFieldExistsQuery(QueryShardContext context, String field) {
        MappedFieldType fieldType = context.getMapperService().fullName(field);
        if (fieldType == null) {
            if (context.getObjectMapper(field) != null) {
                return ExistsQueryBuilder.newObjectFieldExistsQuery(context, field);
            }
            return Queries.newMatchNoDocsQuery("No field \"" + field + "\" exists in mappings.");
        }
        Query filter = fieldType.existsQuery(context);
        return new ConstantScoreQuery(filter);
    }

    private static Query newObjectFieldExistsQuery(QueryShardContext context, String objField) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        Collection<String> fields = context.simpleMatchToIndexNames(objField + ".*");
        for (String field : fields) {
            Query existsQuery = context.getMapperService().fullName(field).existsQuery(context);
            booleanQuery.add(existsQuery, BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)booleanQuery.build());
    }
}

