/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;

public class TypeParsers {
    public static final String DOC_VALUES = "doc_values";
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";

    private static void parseAnalyzersAndTermVectors(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        NamedAnalyzer indexAnalyzer = null;
        NamedAnalyzer searchAnalyzer = null;
        NamedAnalyzer searchQuoteAnalyzer = null;
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            NamedAnalyzer analyzer;
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (propName.equals("term_vector")) {
                TypeParsers.parseTermVector(name, propNode.toString(), builder);
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vectors")) {
                builder.storeTermVectors(XContentMapValues.nodeBooleanValue(propNode, name + ".store_term_vectors"));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_offsets")) {
                builder.storeTermVectorOffsets(XContentMapValues.nodeBooleanValue(propNode, name + ".store_term_vector_offsets"));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_positions")) {
                builder.storeTermVectorPositions(XContentMapValues.nodeBooleanValue(name + ".store_term_vector_positions"));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_payloads")) {
                builder.storeTermVectorPayloads(XContentMapValues.nodeBooleanValue(name + ".store_term_vector_payloads"));
                iterator.remove();
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                indexAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                searchAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (!propName.equals("search_quote_analyzer")) continue;
            analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
            if (analyzer == null) {
                throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
            }
            searchQuoteAnalyzer = analyzer;
            iterator.remove();
        }
        if (indexAnalyzer == null && searchAnalyzer != null) {
            throw new MapperParsingException("analyzer on field [" + name + "] must be set when search_analyzer is set");
        }
        if (searchAnalyzer == null && searchQuoteAnalyzer != null) {
            throw new MapperParsingException("analyzer and search_analyzer on field [" + name + "] must be set when search_quote_analyzer is set");
        }
        if (searchAnalyzer == null) {
            searchAnalyzer = indexAnalyzer;
        }
        if (searchQuoteAnalyzer == null) {
            searchQuoteAnalyzer = searchAnalyzer;
        }
        if (indexAnalyzer != null) {
            builder.indexAnalyzer(indexAnalyzer);
        }
        if (searchAnalyzer != null) {
            builder.searchAnalyzer(searchAnalyzer);
        }
        if (searchQuoteAnalyzer != null) {
            builder.searchQuoteAnalyzer(searchQuoteAnalyzer);
        }
    }

    public static void parseNorms(FieldMapper.Builder builder, String fieldName, Object propNode) {
        builder.omitNorms(!XContentMapValues.nodeBooleanValue(propNode, fieldName + ".norms"));
    }

    public static void parseTextField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, fieldNode, parserContext);
        TypeParsers.parseAnalyzersAndTermVectors(builder, name, fieldNode, parserContext);
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (!"norms".equals(propName)) continue;
            TypeParsers.parseNorms(builder, name, propNode);
            iterator.remove();
        }
    }

    public static void parseField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (!propName.equals("null_value") && propNode == null) {
                throw new MapperParsingException("[" + propName + "] must not have a [null] value");
            }
            if (propName.equals("store")) {
                builder.store(XContentMapValues.nodeBooleanValue(propNode, name + ".store"));
                iterator.remove();
                continue;
            }
            if (propName.equals("index")) {
                builder.index(XContentMapValues.nodeBooleanValue(propNode, name + ".index"));
                iterator.remove();
                continue;
            }
            if (propName.equals(DOC_VALUES)) {
                builder.docValues(XContentMapValues.nodeBooleanValue(propNode, name + ".doc_values"));
                iterator.remove();
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("include_in_all")) {
                throw new MapperParsingException("[include_in_all] is not allowed for indices created on or after version 6.0.0 as [_all] is deprecated. As a replacement, you can use an [copy_to] on mapping fields to create your own catch all field.");
            }
            if (propName.equals("copy_to")) {
                TypeParsers.parseCopyFields(propNode, builder);
                iterator.remove();
                continue;
            }
            if (propName.equals("position")) {
                builder.position(XContentMapValues.nodeIntegerValue(propNode));
                iterator.remove();
                continue;
            }
            if (!propName.equals("default_expr")) continue;
            builder.defaultExpression(XContentMapValues.nodeStringValue(propNode, null));
            iterator.remove();
        }
    }

    private static IndexOptions nodeIndexOptionValue(Object propNode) {
        String value = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS;
        }
        throw new ElasticsearchParseException("failed to parse index option [{}]", value);
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(Object node) {
        if (node instanceof String) {
            return Joda.forPattern((String)node);
        }
        throw new IllegalArgumentException("Invalid format: [" + node.toString() + "]: expected string value");
    }

    public static void parseTermVector(String fieldName, String termVector, FieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(termVector)) {
            builder.storeTermVectors(false);
        } else if ("yes".equals(termVector)) {
            builder.storeTermVectors(true);
        } else if ("with_offsets".equals(termVector)) {
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions".equals(termVector)) {
            builder.storeTermVectorPositions(true);
        } else if ("with_positions_offsets".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorPayloads(true);
        } else if ("with_positions_offsets_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
            builder.storeTermVectorPayloads(true);
        } else {
            throw new MapperParsingException("wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
        }
    }

    public static void parseCopyFields(Object propNode, FieldMapper.Builder builder) {
        FieldMapper.CopyTo.Builder copyToBuilder = new FieldMapper.CopyTo.Builder();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyToBuilder.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyToBuilder.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        builder.copyTo(copyToBuilder.build());
    }
}

