/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_source";
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String CONTENT_TYPE = "_source";
    private final boolean enabled;

    private SourceFieldMapper(Settings indexSettings) {
        this(true, indexSettings);
    }

    private SourceFieldMapper(boolean enabled, Settings indexSettings) {
        super("_source", null, Defaults.FIELD_TYPE.clone(), Defaults.FIELD_TYPE, indexSettings);
        this.enabled = enabled;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        BytesRef ref;
        BytesReference originalSource;
        BytesReference source = originalSource = context.sourceToParse().source();
        if (this.enabled && this.fieldType().stored() && source != null) {
            ref = source.toBytesRef();
            fields.add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        } else {
            source = null;
        }
        if (originalSource != null && source != originalSource && context.indexSettings().isSoftDeleteEnabled()) {
            ref = originalSource.toBytesRef();
            fields.add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, ref.bytes, ref.offset, ref.length));
            fields.add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabled) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || !this.enabled) {
            builder.field("enabled", this.enabled);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        SourceFieldMapper sourceMergeWith = (SourceFieldMapper)mergeWith;
        ArrayList<String> conflicts = new ArrayList<String>();
        if (this.enabled != sourceMergeWith.enabled) {
            conflicts.add("Cannot update enabled setting for [_source]");
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("Can't merge because of conflicts: " + conflicts);
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final MappedFieldType FIELD_TYPE = new SourceFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_source");
            FIELD_TYPE.freeze();
        }
    }

    static final class SourceFieldType
    extends MappedFieldType {
        SourceFieldType() {
        }

        protected SourceFieldType(SourceFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new SourceFieldType(this);
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode, name + ".enabled"));
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new SourceFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, SourceFieldMapper> {
        private boolean enabled = true;

        public Builder() {
            super("_source", Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public SourceFieldMapper build(Mapper.BuilderContext context) {
            return new SourceFieldMapper(this.enabled, context.indexSettings());
        }
    }
}

