/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;

public class ParsedDocument {
    private final Field version;
    private final String id;
    private final SeqNoFieldMapper.SequenceIDFields seqID;
    private final String routing;
    private final List<ParseContext.Document> documents;
    private final BytesReference source;
    private final Mapping dynamicMappingsUpdate;

    public ParsedDocument(Field version, SeqNoFieldMapper.SequenceIDFields seqID, String id, String routing, List<ParseContext.Document> documents, BytesReference source, Mapping dynamicMappingsUpdate) {
        this.version = version;
        this.seqID = seqID;
        this.id = id;
        this.routing = routing;
        this.documents = documents;
        this.source = source;
        this.dynamicMappingsUpdate = dynamicMappingsUpdate;
    }

    public String id() {
        return this.id;
    }

    public Field version() {
        return this.version;
    }

    public void updateSeqID(long sequenceNumber, long primaryTerm) {
        this.seqID.seqNo.setLongValue(sequenceNumber);
        this.seqID.seqNoDocValue.setLongValue(sequenceNumber);
        this.seqID.primaryTerm.setLongValue(primaryTerm);
    }

    ParsedDocument toTombstone() {
        assert (this.docs().size() == 1) : "Tombstone should have a single doc [" + this.docs() + "]";
        this.seqID.tombstoneField.setLongValue(1L);
        this.rootDoc().add((IndexableField)this.seqID.tombstoneField);
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ParseContext.Document rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<ParseContext.Document> docs() {
        return this.documents;
    }

    public BytesReference source() {
        return this.source;
    }

    public Mapping dynamicMappingsUpdate() {
        return this.dynamicMappingsUpdate;
    }

    public String toString() {
        return "Document id[" + this.id + "] doc [" + this.documents + "]";
    }
}

