/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.ArrayMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ObjectMapper;

public class ObjectArrayMapper
extends ObjectMapper {
    private ObjectMapper innerMapper;

    ObjectArrayMapper(String name, ObjectMapper innerMapper, Settings settings) {
        super(name, innerMapper.position(), innerMapper.fullPath(), innerMapper.isEnabled(), innerMapper.dynamic(), Collections.emptyMap(), settings);
        this.innerMapper = innerMapper;
    }

    @Override
    public Mapper getMapper(String field) {
        return this.innerMapper.getMapper(field);
    }

    @Override
    protected void putMapper(Mapper mapper) {
        this.innerMapper.putMapper(mapper);
    }

    @Override
    public ObjectMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapper updatedMapper = this.innerMapper.updateFieldType((Map)fullNameToFieldType);
        if (this.innerMapper != updatedMapper) {
            ObjectArrayMapper clone = this.clone();
            clone.innerMapper = updatedMapper;
            return clone;
        }
        return this;
    }

    @Override
    public ObjectMapper mappingUpdate(Mapper mapper) {
        ObjectMapper updatedMapper = this.innerMapper.mappingUpdate(mapper);
        if (this.innerMapper != updatedMapper) {
            ObjectArrayMapper clone = this.clone();
            clone.innerMapper = updatedMapper;
            return clone;
        }
        return this;
    }

    @Override
    protected ObjectArrayMapper clone() {
        return (ObjectArrayMapper)super.clone();
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith) {
        ObjectArrayMapper merged = this.clone();
        if (mergeWith instanceof ObjectArrayMapper) {
            ObjectArrayMapper mergeWithObject = (ObjectArrayMapper)mergeWith;
            merged.innerMapper = merged.innerMapper.merge(mergeWithObject.innerMapper);
            return merged;
        }
        merged.innerMapper = merged.innerMapper.merge(mergeWith);
        return merged;
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith) {
        throw new UnsupportedOperationException("doMerge not supported");
    }

    @Override
    public void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom) throws IOException {
        ArrayMapper.toXContent(builder, params, this.innerMapper, this.simpleName(), "array");
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.innerMapper.iterator();
    }

    static class Builder
    extends ObjectMapper.Builder {
        private final ObjectMapper.Builder innerBuilder;

        Builder(String name, ObjectMapper.Builder innerBuilder) {
            super(name);
            this.innerBuilder = innerBuilder;
        }

        @Override
        public ObjectMapper build(Mapper.BuilderContext context) {
            return new ObjectArrayMapper(this.name, (ObjectMapper)this.innerBuilder.build(context), context.indexSettings());
        }

        protected ObjectMapper createMapper(String name, Integer position, String fullPath, boolean enabled, ObjectMapper.Dynamic dynamic, Map mappers, @Nullable Settings settings) {
            return new ObjectArrayMapper(name, super.createMapper(name, position, fullPath, enabled, dynamic, mappers, settings), settings);
        }
    }
}

