/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectHashSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.elasticsearch.Assertions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperMergeValidator;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String SINGLE_MAPPING_NAME = "default";
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final ObjectHashSet<String> META_FIELDS = ObjectHashSet.from((Object[])new String[]{"_id", "_type", "_routing", "_index", "_size", "_timestamp", "_ttl", "_ignored"});
    private final IndexAnalyzers indexAnalyzers;
    private volatile DocumentMapper mapper;
    private volatile FieldTypeLookup fieldTypes;
    private volatile Map<String, ObjectMapper> fullPathObjectMappers = Collections.emptyMap();
    private final DocumentMapperParser documentParser;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    final MapperRegistry mapperRegistry;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier) {
        super(indexSettings);
        this.indexAnalyzers = indexAnalyzers;
        this.fieldTypes = new FieldTypeLookup();
        this.documentParser = new DocumentMapperParser(indexSettings, this, xContentRegistry, mapperRegistry, queryShardContextSupplier);
        this.indexAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), MappedFieldType::indexAnalyzer);
        this.searchAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), MappedFieldType::searchAnalyzer);
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer(), MappedFieldType::searchQuoteAnalyzer);
        this.mapperRegistry = mapperRegistry;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws Exception {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        String op;
        DocumentMapper updatedMapper;
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetadata.getIndex();
        try {
            updatedMapper = this.internalMerge(newIndexMetadata, MergeReason.MAPPING_RECOVERY, true);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        if (updatedMapper == null) {
            return false;
        }
        boolean requireRefresh = false;
        this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, updatedMapper);
        MappingMetadata mappingMetadata = newIndexMetadata.mapping();
        CompressedXContent incomingMappingSource = mappingMetadata.source();
        String string = op = this.mapper != null ? "updated" : "added";
        if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
            this.logger.debug("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
        } else {
            this.logger.debug("[{}] {} mapping (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op);
        }
        if (!this.documentMapper().mappingSource().equals(incomingMappingSource)) {
            this.logger.debug("[{}] parsed mapping, and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)incomingMappingSource, (Object)this.documentMapper().mappingSource());
            requireRefresh = true;
        }
        return requireRefresh;
    }

    private void assertMappingVersion(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata, DocumentMapper updatedMapper) {
        if (Assertions.ENABLED && currentIndexMetadata != null) {
            if (currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
                assert (updatedMapper == this.mapper);
                MappingMetadata mapping = newIndexMetadata.mapping();
                if (mapping != null) {
                    CompressedXContent currentSource = currentIndexMetadata.mapping().source();
                    CompressedXContent newSource = mapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + newSource + "]";
                }
            } else {
                long currentMappingVersion = currentIndexMetadata.getMappingVersion();
                long newMappingVersion = newIndexMetadata.getMappingVersion();
                assert (currentMappingVersion < newMappingVersion) : "expected current mapping version [" + currentMappingVersion + "] to be less than new mapping version [" + newMappingVersion + "]";
                assert (updatedMapper != null);
                MappingMetadata currentMapping = currentIndexMetadata.mapping();
                if (currentMapping != null) {
                    CompressedXContent currentSource = currentMapping.source();
                    CompressedXContent newSource = updatedMapper.mappingSource();
                    assert (!currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] to be different than new mapping";
                }
            }
        }
    }

    public void merge(String type, Map<String, Object> mappings, MergeReason reason) throws IOException {
        CompressedXContent content = new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(mappings)));
        this.internalMerge(type, content, reason);
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        this.internalMerge(indexMetadata, reason, false);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.internalMerge(type, mappingSource, reason);
    }

    private synchronized DocumentMapper internalMerge(IndexMetadata indexMetaData, MergeReason reason, boolean onlyUpdateIfNeeded) {
        MappingMetadata mappingMetadata = indexMetaData.mapping();
        if (mappingMetadata != null) {
            if (onlyUpdateIfNeeded) {
                DocumentMapper existingMapper = this.documentMapper();
                if (existingMapper == null || !mappingMetadata.source().equals(existingMapper.mappingSource())) {
                    return this.internalMerge(mappingMetadata.type(), mappingMetadata.source(), reason);
                }
            } else {
                return this.internalMerge(mappingMetadata.type(), mappingMetadata.source(), reason);
            }
        }
        return null;
    }

    private synchronized DocumentMapper internalMerge(String type, CompressedXContent mappings, MergeReason reason) {
        DocumentMapper documentMapper;
        try {
            documentMapper = this.documentParser.parse(type, mappings);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
        }
        return this.internalMerge(documentMapper, reason);
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !SINGLE_MAPPING_NAME.equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [default]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    private synchronized DocumentMapper internalMerge(DocumentMapper mapper, MergeReason reason) {
        DocumentMapper updatedDocumentMapper;
        Map<String, ObjectMapper> fullPathObjectMappers = this.fullPathObjectMappers;
        assert (mapper != null);
        MapperService.validateTypeName(mapper.type());
        DocumentMapper oldMapper = this.mapper;
        DocumentMapper newMapper = oldMapper != null ? oldMapper.merge(mapper.mapping()) : mapper;
        ArrayList<ObjectMapper> objectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> fieldAliasMappers = new ArrayList<FieldAliasMapper>();
        MetadataFieldMapper[] metadataMappers = newMapper.mapping().metadataMappers;
        Collections.addAll(fieldMappers, metadataMappers);
        MapperUtils.collect(newMapper.mapping().root(), objectMappers, fieldMappers, fieldAliasMappers);
        FieldTypeLookup fieldTypes = this.fieldTypes;
        MapperMergeValidator.validateNewMappers(objectMappers, fieldMappers, fieldAliasMappers, fieldTypes);
        this.checkPartitionedIndexConstraints(newMapper);
        fieldTypes = fieldTypes.copyAndAddAll(newMapper.type(), fieldMappers, fieldAliasMappers);
        for (ObjectMapper objectMapper : objectMappers) {
            if (fullPathObjectMappers == this.fullPathObjectMappers) {
                fullPathObjectMappers = new HashMap<String, ObjectMapper>(this.fullPathObjectMappers);
            }
            fullPathObjectMappers.put(objectMapper.fullPath(), objectMapper);
        }
        if (reason == MergeReason.MAPPING_UPDATE) {
            this.checkTotalFieldsLimit(objectMappers.size() + fieldMappers.size() - metadataMappers.length + fieldAliasMappers.size());
            this.checkDepthLimit(fullPathObjectMappers.keySet());
        }
        if (newMapper != null && (updatedDocumentMapper = newMapper.updateFieldType(fieldTypes.fullNameToFieldType)) != newMapper) {
            newMapper = updatedDocumentMapper;
        }
        if (fullPathObjectMappers != this.fullPathObjectMappers) {
            fullPathObjectMappers = Collections.unmodifiableMap(fullPathObjectMappers);
        }
        if (newMapper != null) {
            this.mapper = newMapper;
        }
        this.fieldTypes = fieldTypes;
        this.fullPathObjectMappers = fullPathObjectMappers;
        assert (this.assertMappersShareSameFieldType());
        assert (newMapper == null || this.assertSerialization(newMapper));
        return newMapper;
    }

    private boolean assertMappersShareSameFieldType() {
        if (this.mapper != null) {
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            Collections.addAll(fieldMappers, this.mapper.mapping().metadataMappers);
            MapperUtils.collect(this.mapper.root(), new ArrayList<ObjectMapper>(), fieldMappers, new ArrayList<FieldAliasMapper>());
            for (FieldMapper fieldMapper : fieldMappers) {
                assert (fieldMapper.fieldType() == this.fieldTypes.get(fieldMapper.name())) : fieldMapper.name();
            }
        }
        return true;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    private void checkTotalFieldsLimit(long totalMappers) {
        long allowedTotalFields = this.indexSettings.getValue(INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING);
        if (allowedTotalFields < totalMappers) {
            throw new IllegalArgumentException("Limit of total fields [" + allowedTotalFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkDepthLimit(Collection<String> objectPaths) {
        long maxDepth = this.indexSettings.getValue(INDEX_MAPPING_DEPTH_LIMIT_SETTING);
        for (String objectPath : objectPaths) {
            this.checkDepthLimit(objectPath, maxDepth);
        }
    }

    private void checkDepthLimit(String objectPath, long maxDepth) {
        int numDots = 0;
        for (int i = 0; i < objectPath.length(); ++i) {
            if (objectPath.charAt(i) != '.') continue;
            ++numDots;
        }
        int depth = numDots + 2;
        if ((long)depth > maxDepth) {
            throw new IllegalArgumentException("Limit of mapping depth [" + maxDepth + "] in index [" + this.index().getName() + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkPartitionedIndexConstraints(DocumentMapper newMapper) {
        if (this.indexSettings.getIndexMetadata().isRoutingPartitionedIndex() && !newMapper.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + newMapper.type() + "] must have routing required for partitioned index [" + this.indexSettings.getIndex().getName() + "]");
        }
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource);
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public MappedFieldType fullName(String fullName) {
        return this.fieldTypes.get(fullName);
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singletonList(pattern);
        }
        return this.fieldTypes.simpleMatchToFullName(pattern);
    }

    public Iterable<MappedFieldType> fieldTypes() {
        return this.fieldTypes;
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.fullPathObjectMappers.get(name);
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public static boolean isMetadataField(String fieldName) {
        return META_FIELDS.contains((Object)fieldName);
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.fullName(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    public static enum MergeReason {
        MAPPING_UPDATE,
        MAPPING_RECOVERY;

    }
}

