/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ObjectMapper;

class MapperMergeValidator {
    MapperMergeValidator() {
    }

    public static void validateNewMappers(Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, FieldTypeLookup fieldTypes) {
        HashSet<String> objectFullNames = new HashSet<String>();
        for (ObjectMapper objectMapper : objectMappers) {
            String fullPath = objectMapper.fullPath();
            if (objectFullNames.add(fullPath)) continue;
            throw new IllegalArgumentException("Object mapper [" + fullPath + "] is defined twice.");
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String name = fieldMapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field.");
            }
            if (!fieldNames.add(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined twice.");
            }
            MapperMergeValidator.validateFieldMapper(fieldMapper, fieldTypes);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String name = fieldAliasMapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field.");
            }
            if (fieldNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an alias and a concrete field.");
            }
            if (!hashSet.add(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined twice.");
            }
            MapperMergeValidator.validateFieldAliasMapper(name, fieldAliasMapper.path(), fieldNames, hashSet);
        }
    }

    private static void validateFieldMapper(FieldMapper fieldMapper, FieldTypeLookup fieldTypes) {
        MappedFieldType newFieldType = fieldMapper.fieldType();
        MappedFieldType existingFieldType = fieldTypes.get(newFieldType.name());
        if (existingFieldType != null && !Objects.equals((Object)newFieldType, (Object)existingFieldType)) {
            ArrayList<String> conflicts = new ArrayList<String>();
            existingFieldType.checkCompatibility(newFieldType, conflicts);
            if (!conflicts.isEmpty()) {
                throw new IllegalArgumentException("Mapper for [" + newFieldType.name() + "] conflicts with existing mapping:\n" + ((Object)conflicts).toString());
            }
        }
    }

    private static void validateFieldAliasMapper(String aliasName, String path, Set<String> fieldMappers, Set<String> fieldAliasMappers) {
        if (path.equals(aliasName)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to itself.");
        }
        if (fieldAliasMappers.contains(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to another alias.");
        }
        if (!fieldMappers.contains(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias must refer to an existing field in the mappings.");
        }
    }
}

