/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.joda.time.DateTimeZone;

public abstract class MappedFieldType
extends FieldType {
    private String name;
    private float boost;
    private boolean docValues;
    private NamedAnalyzer indexAnalyzer;
    private NamedAnalyzer searchAnalyzer;
    private NamedAnalyzer searchQuoteAnalyzer;
    private Object nullValue;
    private String nullValueAsString;
    private boolean eagerGlobalOrdinals;

    protected MappedFieldType(MappedFieldType ref) {
        super((IndexableFieldType)ref);
        this.name = ref.name();
        this.boost = ref.boost();
        this.docValues = ref.hasDocValues();
        this.indexAnalyzer = ref.indexAnalyzer();
        this.searchAnalyzer = ref.searchAnalyzer();
        this.searchQuoteAnalyzer = ref.searchQuoteAnalyzer();
        this.nullValue = ref.nullValue();
        this.nullValueAsString = ref.nullValueAsString();
        this.eagerGlobalOrdinals = ref.eagerGlobalOrdinals;
    }

    public MappedFieldType() {
        this.setTokenized(true);
        this.setStored(false);
        this.setStoreTermVectors(false);
        this.setOmitNorms(false);
        this.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.setBoost(1.0f);
    }

    public abstract MappedFieldType clone();

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MappedFieldType fieldType = (MappedFieldType)((Object)o);
        return this.boost == fieldType.boost && this.docValues == fieldType.docValues && Objects.equals(this.name, fieldType.name) && Objects.equals((Object)this.indexAnalyzer, (Object)fieldType.indexAnalyzer) && Objects.equals((Object)this.searchAnalyzer, (Object)fieldType.searchAnalyzer) && Objects.equals((Object)this.searchQuoteAnalyzer(), (Object)fieldType.searchQuoteAnalyzer()) && Objects.equals(this.eagerGlobalOrdinals, fieldType.eagerGlobalOrdinals) && Objects.equals(this.nullValue, fieldType.nullValue) && Objects.equals(this.nullValueAsString, fieldType.nullValueAsString);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, Float.valueOf(this.boost), this.docValues, this.indexAnalyzer, this.searchAnalyzer, this.searchQuoteAnalyzer, this.eagerGlobalOrdinals, this.nullValue, this.nullValueAsString});
    }

    public abstract String typeName();

    private void checkTypeName(MappedFieldType other) {
        if (!this.typeName().equals(other.typeName())) {
            throw new IllegalArgumentException("mapper [" + this.name + "] cannot be changed from type [" + this.typeName() + "] to [" + other.typeName() + "]");
        }
        if (((Object)((Object)this)).getClass() != ((Object)((Object)other)).getClass()) {
            throw new IllegalStateException("Type names equal for class " + ((Object)((Object)this)).getClass().getSimpleName() + " and " + ((Object)((Object)other)).getClass().getSimpleName());
        }
    }

    public void checkCompatibility(MappedFieldType other, List<String> conflicts) {
        boolean mergeWithIndexed;
        this.checkTypeName(other);
        boolean indexed = this.indexOptions() != IndexOptions.NONE;
        boolean bl = mergeWithIndexed = other.indexOptions() != IndexOptions.NONE;
        if (indexed != mergeWithIndexed) {
            conflicts.add("mapper [" + this.name() + "] has different [index] values");
        }
        if (this.stored() != other.stored()) {
            conflicts.add("mapper [" + this.name() + "] has different [store] values");
        }
        if (this.hasDocValues() != other.hasDocValues()) {
            conflicts.add("mapper [" + this.name() + "] has different [doc_values] values");
        }
        if (this.omitNorms() && !other.omitNorms()) {
            conflicts.add("mapper [" + this.name() + "] has different [norms] values, cannot change from disable to enabled");
        }
        if (this.storeTermVectors() != other.storeTermVectors()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector] values");
        }
        if (this.storeTermVectorOffsets() != other.storeTermVectorOffsets()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_offsets] values");
        }
        if (this.storeTermVectorPositions() != other.storeTermVectorPositions()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_positions] values");
        }
        if (this.storeTermVectorPayloads() != other.storeTermVectorPayloads()) {
            conflicts.add("mapper [" + this.name() + "] has different [store_term_vector_payloads] values");
        }
        if (this.indexAnalyzer() == null || "default".equals(this.indexAnalyzer().name())) {
            if (other.indexAnalyzer() != null && !"default".equals(other.indexAnalyzer().name())) {
                conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
            }
        } else if (other.indexAnalyzer() == null || "default".equals(other.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
        } else if (!this.indexAnalyzer().name().equals(other.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.name() + "] has different [analyzer]");
        }
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.checkIfFrozen();
        this.name = name;
    }

    public float boost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.checkIfFrozen();
        this.boost = boost;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public void setHasDocValues(boolean hasDocValues) {
        this.checkIfFrozen();
        this.docValues = hasDocValues;
    }

    public NamedAnalyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void setIndexAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.indexAnalyzer = analyzer;
    }

    public NamedAnalyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public void setSearchAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchAnalyzer = analyzer;
    }

    public NamedAnalyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer == null ? this.searchAnalyzer : this.searchQuoteAnalyzer;
    }

    public void setSearchQuoteAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchQuoteAnalyzer = analyzer;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public String nullValueAsString() {
        return this.nullValueAsString;
    }

    public void setNullValue(Object nullValue) {
        this.checkIfFrozen();
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    public Object valueForDisplay(Object value) {
        return value;
    }

    public boolean isSearchable() {
        return this.indexOptions() != IndexOptions.NONE;
    }

    public abstract Query termQuery(Object var1, @Nullable QueryShardContext var2);

    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : values) {
            builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, DateTimeZone timeZone, QueryShardContext context) {
        throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support range queries");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use prefix queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query nullValueQuery() {
        if (this.nullValue == null) {
            return null;
        }
        return new ConstantScoreQuery(this.termQuery(this.nullValue, null));
    }

    public abstract Query existsQuery(QueryShardContext var1);

    public Query phraseQuery(String field, TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        throw new IllegalArgumentException("Attempted to build a phrase query with multiple terms against non-text field [" + this.name + "]");
    }

    public Query multiPhraseQuery(String field, TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        throw new IllegalArgumentException("Attempted to build a phrase query with multiple terms against non-text field [" + this.name + "]");
    }

    @Nullable
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    protected final void failIfNoDocValues() {
        if (!this.hasDocValues()) {
            throw new IllegalArgumentException("Can't load fielddata on [" + this.name() + "] because fielddata is unsupported on fields of type [" + this.typeName() + "]. Use doc values instead.");
        }
    }

    protected final void failIfNotIndexed() {
        if (this.indexOptions() == IndexOptions.NONE && this.pointDimensionCount() == 0) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed.");
        }
    }

    public boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public void setEagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
        this.checkIfFrozen();
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }
}

