/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;

public class IpFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "ip";
    private Explicit<Boolean> ignoreMalformed;

    private IpFieldMapper(String simpleName, Integer position, String defaultExpression, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, position, defaultExpression, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected IpFieldMapper clone() {
        return (IpFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        InetAddress address;
        Object addressAsObject = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (addressAsObject == null) {
            addressAsObject = this.fieldType().nullValue();
        }
        if (addressAsObject == null) {
            return;
        }
        String addressAsString = addressAsObject.toString();
        if (addressAsObject instanceof InetAddress) {
            address = (InetAddress)addressAsObject;
        } else {
            try {
                address = InetAddresses.forString(addressAsString);
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    context.addIgnoredField(this.fieldType.name());
                    return;
                }
                throw e;
            }
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            fields.add((IndexableField)new InetAddressPoint(this.fieldType().name(), address));
        }
        if (this.fieldType().hasDocValues()) {
            fields.add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else if (this.fieldType().stored() || this.fieldType().indexOptions() != IndexOptions.NONE) {
            this.createFieldNamesField(context, fields);
        }
        if (this.fieldType().stored()) {
            fields.add((IndexableField)new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        IpFieldMapper other = (IpFieldMapper)mergeWith;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            Object nullValue = this.fieldType().nullValue();
            if (nullValue != null) {
                nullValue = InetAddresses.toAddrString((InetAddress)nullValue);
            }
            builder.field("null_value", nullValue);
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        public IpFieldType() {
            this.setTokenized(false);
            this.setHasDocValues(true);
        }

        IpFieldType(IpFieldType other) {
            super(other);
        }

        @Override
        public MappedFieldType clone() {
            return new IpFieldType(this);
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String term;
            this.failIfNotIndexed();
            if (value instanceof InetAddress) {
                return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if ((term = value.toString()).contains("/")) {
                Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                return InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)cidr.v1(), (int)cidr.v2());
            }
            InetAddress address = InetAddresses.forString(term);
            return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            InetAddress upper;
            InetAddress lower;
            this.failIfNotIndexed();
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = this.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = this.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(InetAddresses.forString(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("ignore_malformed")) continue;
                builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, IpFieldMapper> {
        private Boolean ignoreMalformed;

        public Builder(String name) {
            super(name, new IpFieldType(), new IpFieldType());
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new IpFieldMapper(this.name, this.position, this.defaultExpression, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }
}

