/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public final class IgnoredFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_ignored";
    public static final String CONTENT_TYPE = "_ignored";

    private IgnoredFieldMapper(Settings indexSettings) {
        super("_ignored", null, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        for (String field : context.getIgnoredFields()) {
            context.doc().add((IndexableField)new Field("_ignored", (CharSequence)field, (IndexableFieldType)this.fieldType()));
        }
    }

    @Override
    protected String contentType() {
        return "_ignored";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Defaults {
        public static final String NAME = "_ignored";
        public static final MappedFieldType FIELD_TYPE = new IgnoredFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_ignored");
            FIELD_TYPE.freeze();
        }
    }

    public static final class IgnoredFieldType
    extends StringFieldType {
        public IgnoredFieldType() {
        }

        protected IgnoredFieldType(IgnoredFieldType ref) {
            super(ref);
        }

        @Override
        public IgnoredFieldType clone() {
            return new IgnoredFieldType(this);
        }

        @Override
        public String typeName() {
            return "_ignored";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermRangeQuery(this.name(), null, null, true, true);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(parserContext.mapperService().fullName("_ignored"));
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new IgnoredFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, IgnoredFieldMapper> {
        public Builder(MappedFieldType existing) {
            super("_ignored", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        @Override
        public IgnoredFieldMapper build(Mapper.BuilderContext context) {
            return new IgnoredFieldMapper(context.indexSettings());
        }
    }
}

