/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryShardContext;

public class IdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_id";
    public static final String CONTENT_TYPE = "_id";

    static MappedFieldType defaultFieldType(IndexSettings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        defaultFieldType.setIndexOptions(IndexOptions.DOCS);
        defaultFieldType.setStored(true);
        return defaultFieldType;
    }

    private IdFieldMapper(IndexSettings indexSettings, MappedFieldType existing) {
        this(existing == null ? IdFieldMapper.defaultFieldType(indexSettings) : existing, indexSettings);
    }

    private IdFieldMapper(MappedFieldType fieldType, IndexSettings indexSettings) {
        super("_id", null, fieldType, IdFieldMapper.defaultFieldType(indexSettings), indexSettings.getSettings());
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            BytesRef id = Uid.encodeId(context.sourceToParse().id());
            fields.add((IndexableField)new Field("_id", id, (IndexableFieldType)this.fieldType));
        }
    }

    @Override
    protected String contentType() {
        return "_id";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
    }

    public static class Defaults {
        public static final String NAME = "_id";
        public static final MappedFieldType FIELD_TYPE = new IdFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_id");
            FIELD_TYPE.freeze();
        }
    }

    static final class IdFieldType
    extends StringFieldType {
        IdFieldType() {
        }

        protected IdFieldType(IdFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new IdFieldType(this);
        }

        @Override
        public String typeName() {
            return "_id";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexed();
            BytesRef[] bytesRefs = new BytesRef[values.size()];
            for (int i = 0; i < bytesRefs.length; ++i) {
                Object idObject = values.get(i);
                if (idObject instanceof BytesRef) {
                    idObject = ((BytesRef)idObject).utf8ToString();
                }
                bytesRefs[i] = Uid.encodeId(idObject.toString());
            }
            return new TermInSetQuery(this.name(), bytesRefs);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_id is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new IdFieldMapper(indexSettings, fieldType);
        }
    }
}

