/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class FieldNamesFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";

    private FieldNamesFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing.clone(), indexSettings);
    }

    private FieldNamesFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_field_names", null, fieldType, Defaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public FieldNamesFieldType fieldType() {
        return (FieldNamesFieldType)super.fieldType();
    }

    @Override
    public void preParse(ParseContext context) {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int endIndex = this.nextEndIndex(0);

                    private int nextEndIndex(int index) {
                        while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                            ++index;
                        }
                        return index;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.endIndex <= fullPath.length();
                    }

                    @Override
                    public String next() {
                        String result = fullPath.substring(0, this.endIndex);
                        this.endIndex = this.nextEndIndex(this.endIndex + 1);
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        for (ParseContext.Document document : context) {
            ArrayList<String> paths = new ArrayList<String>(document.getFields().size());
            String previousPath = "";
            for (IndexableField field : document.getFields()) {
                String path = field.name();
                if (path.equals(previousPath)) continue;
                paths.add(path);
                previousPath = path;
            }
            for (String path : paths) {
                for (String fieldName : FieldNamesFieldMapper.extractFieldNames(path)) {
                    if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) continue;
                    document.add((IndexableField)new Field(this.fieldType().name(), (CharSequence)fieldName, (IndexableFieldType)this.fieldType()));
                }
            }
        }
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults) {
            return builder;
        }
        builder.startObject("_field_names");
        if (includeDefaults) {
            builder.field("enabled", true);
        }
        builder.endObject();
        return builder;
    }

    public static class Defaults {
        public static final String NAME = "_field_names";
        public static final MappedFieldType FIELD_TYPE = new FieldNamesFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_field_names");
            FIELD_TYPE.freeze();
        }
    }

    public static final class FieldNamesFieldType
    extends TermBasedFieldType {
        public FieldNamesFieldType() {
        }

        protected FieldNamesFieldType(FieldNamesFieldType ref) {
            super(ref);
        }

        @Override
        public FieldNamesFieldType clone() {
            return new FieldNamesFieldType(this);
        }

        @Override
        public String typeName() {
            return "_field_names";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on _field_names");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Terms query on _field_names is no longer supported");
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(parserContext.mapperService().fullName("_field_names"));
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new FieldNamesFieldMapper(indexSettings, fieldType);
            }
            return (MetadataFieldMapper)this.parse("_field_names", Collections.emptyMap(), context).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, FieldNamesFieldMapper> {
        public Builder(MappedFieldType existing) {
            super("_field_names", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        @Override
        @Deprecated
        public Builder index(boolean index) {
            return (Builder)super.index(index);
        }

        @Override
        public FieldNamesFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldType)this.fieldType;
            return new FieldNamesFieldMapper(this.fieldType, context.indexSettings());
        }
    }
}

