/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public class DocumentMapper
implements ToXContentFragment {
    private final MapperService mapperService;
    private final String type;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final DocumentFieldMappers fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final MetadataFieldMapper[] deleteTombstoneMetadataFieldMappers;
    private final MetadataFieldMapper[] noopTombstoneMetadataFieldMappers;

    public DocumentMapper(MapperService mapperService, Mapping mapping) {
        this.mapperService = mapperService;
        this.type = mapping.root().name();
        IndexSettings indexSettings = mapperService.getIndexSettings();
        this.mapping = mapping;
        this.documentParser = new DocumentParser(indexSettings, mapperService.documentMapperParser(), this);
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> newFieldAliasMappers = new ArrayList<FieldAliasMapper>();
        for (MetadataFieldMapper metadataMapper : this.mapping.metadataMappers) {
            if (metadataMapper == null) continue;
            newFieldMappers.add(metadataMapper);
        }
        MapperUtils.collect(this.mapping.root, newObjectMappers, newFieldMappers, newFieldAliasMappers);
        IndexAnalyzers indexAnalyzers = mapperService.getIndexAnalyzers();
        this.fieldMappers = new DocumentFieldMappers(newFieldMappers, newFieldAliasMappers, (Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), (Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), (Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer());
        HashMap<String, ObjectMapper> builder = new HashMap<String, ObjectMapper>();
        for (ObjectMapper objectMapper : newObjectMappers) {
            ObjectMapper previous = builder.put(objectMapper.fullPath(), objectMapper);
            if (previous == null) continue;
            throw new IllegalStateException("duplicate key " + objectMapper.fullPath() + " encountered");
        }
        this.objectMappers = Collections.unmodifiableMap(builder);
        try {
            this.mappingSource = new CompressedXContent(this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
        List<String> deleteTombstoneMetadataFields = Arrays.asList("_version", "_id", "_seq_no", "_primary_term", "_tombstone");
        this.deleteTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> deleteTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
        List<String> noopTombstoneMetadataFields = Arrays.asList("_version", "_seq_no", "_primary_term", "_tombstone");
        this.noopTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> noopTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mapping.metadataMappers);
    }

    public ParsedDocument createDeleteTombstoneDoc(String index, String id) throws MapperParsingException {
        SourceToParse emptySource = new SourceToParse(index, id, new BytesArray("{}"), XContentType.JSON);
        return this.documentParser.parseDocument(emptySource, this.deleteTombstoneMetadataFieldMappers).toTombstone();
    }

    public ParsedDocument createNoopTombstoneDoc(String index, String reason) throws MapperParsingException {
        String id = "";
        SourceToParse sourceToParse = new SourceToParse(index, "", new BytesArray("{}"), XContentType.JSON);
        ParsedDocument parsedDoc = this.documentParser.parseDocument(sourceToParse, this.noopTombstoneMetadataFieldMappers).toTombstone();
        BytesRef byteRef = new BytesRef((CharSequence)reason);
        parsedDoc.rootDoc().add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return parsedDoc;
    }

    public DocumentMapper merge(Mapping mapping) {
        Mapping merged = this.mapping.merge(mapping);
        return new DocumentMapper(this.mapperService, merged);
    }

    public DocumentMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapping updated = this.mapping.updateFieldType(fullNameToFieldType);
        if (updated == this.mapping) {
            return this;
        }
        assert (updated == updated.updateFieldType(fullNameToFieldType)) : "updateFieldType operation is not idempotent";
        return new DocumentMapper(this.mapperService, updated);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    public static class Builder {
        private Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private final RootObjectMapper rootObjectMapper;
        private Map<String, Object> meta;
        private final Mapper.BuilderContext builderContext;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            Settings indexSettings = mapperService.getIndexSettings().getSettings();
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = builder.build(this.builderContext);
            String type = this.rootObjectMapper.name();
            DocumentMapper existingMapper = mapperService.documentMapper();
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperService.mapperRegistry.getMetadataMapperParsers().entrySet()) {
                MetadataFieldMapper metadataMapper;
                MetadataFieldMapper existingMetadataMapper;
                String name = entry.getKey();
                MetadataFieldMapper metadataFieldMapper = existingMetadataMapper = existingMapper == null ? null : (MetadataFieldMapper)existingMapper.mappers().getMapper(name);
                if (existingMetadataMapper == null) {
                    MetadataFieldMapper.TypeParser parser = entry.getValue();
                    metadataMapper = parser.getDefault(mapperService.fullName(name), mapperService.documentMapperParser().parserContext());
                } else {
                    metadataMapper = existingMetadataMapper;
                }
                this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            }
        }

        public Builder meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder<?, ?> mapper) {
            MetadataFieldMapper metadataMapper = (MetadataFieldMapper)mapper.build(this.builderContext);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public DocumentMapper build(MapperService mapperService) {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(mapperService.getIndexSettings().getIndexVersionCreated(), this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[this.metadataMappers.values().size()]), this.meta);
            return new DocumentMapper(mapperService, mapping);
        }
    }
}

