/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;

public final class DocumentFieldMappers
implements Iterable<Mapper> {
    private final Map<String, Mapper> fieldMappers;

    private static void put(Map<String, Analyzer> analyzers, String key, Analyzer value, Analyzer defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        analyzers.put(key, value);
    }

    public DocumentFieldMappers(Collection<FieldMapper> mappers, Collection<FieldAliasMapper> aliasMappers, Analyzer defaultIndex, Analyzer defaultSearch, Analyzer defaultSearchQuote) {
        HashMap<String, Mapper> fieldMappers = new HashMap<String, Mapper>();
        HashMap<String, Analyzer> indexAnalyzers = new HashMap<String, Analyzer>();
        for (FieldMapper mapper : mappers) {
            fieldMappers.put(mapper.name(), mapper);
            MappedFieldType fieldType = mapper.fieldType();
            DocumentFieldMappers.put(indexAnalyzers, fieldType.name(), (Analyzer)fieldType.indexAnalyzer(), defaultIndex);
        }
        for (FieldAliasMapper aliasMapper : aliasMappers) {
            fieldMappers.put(aliasMapper.name(), aliasMapper);
        }
        this.fieldMappers = Collections.unmodifiableMap(fieldMappers);
    }

    public Mapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.fieldMappers.values().iterator();
    }
}

