/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ArrayFieldType;
import org.elasticsearch.index.mapper.ArrayMapper;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ObjectArrayMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.array.DynamicArrayFieldMapperBuilderFactory;

public class BuilderFactory
implements DynamicArrayFieldMapperBuilderFactory {
    @Override
    public Mapper create(String name, ObjectMapper parentMapper, ParseContext context) {
        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
        try {
            Mapper.Builder<?, ?> innerBuilder = BuilderFactory.detectInnerMapper(context, name, context.parser());
            if (innerBuilder == null) {
                return null;
            }
            Object innerMapper = innerBuilder.build(builderContext);
            if (innerMapper instanceof ObjectMapper) {
                ObjectMapper objectMapper = (ObjectMapper)innerMapper;
                return new ObjectArrayMapper(name, objectMapper, context.indexSettings().getSettings());
            }
            FieldMapper fieldMapper = (FieldMapper)innerMapper;
            ArrayFieldType mappedFieldType = new ArrayFieldType(((FieldMapper.Builder)innerBuilder).fieldType());
            mappedFieldType.setName(name);
            return new ArrayMapper(name, fieldMapper.position(), null, (MappedFieldType)mappedFieldType, ((MappedFieldType)mappedFieldType).clone(), context.indexSettings().getSettings(), FieldMapper.MultiFields.empty(), (Mapper)innerMapper);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Mapper.Builder<?, ?> detectInnerMapper(ParseContext parseContext, String fieldName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = parser.nextToken();
        }
        while (token == XContentParser.Token.VALUE_NULL) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("nested arrays are not supported", new Object[0]);
        }
        if (token == XContentParser.Token.END_ARRAY) {
            return null;
        }
        return DocumentParser.createBuilderFromDynamicValue(parseContext, token, fieldName);
    }
}

