/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import org.elasticsearch.index.mapper.ArrayMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ObjectArrayMapper;
import org.elasticsearch.index.mapper.ObjectMapper;

public class ArrayTypeParser
implements Mapper.TypeParser {
    public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
        Object inner = node.remove("inner");
        if (inner == null) {
            throw new MapperParsingException("property [inner] missing");
        }
        if (!(inner instanceof Map)) {
            throw new MapperParsingException("property [inner] must be a map");
        }
        Map innerNode = (Map)inner;
        String typeName = (String)innerNode.get("type");
        if (typeName == null && innerNode.containsKey("properties")) {
            typeName = "object";
        } else if ("array".equalsIgnoreCase(typeName)) {
            throw new MapperParsingException("nested arrays are not supported");
        }
        Mapper.TypeParser innerTypeParser = parserContext.typeParser(typeName);
        Mapper.Builder<?, ?> innerBuilder = innerTypeParser.parse(name, innerNode, parserContext);
        if (innerBuilder instanceof ObjectMapper.Builder) {
            return new ObjectArrayMapper.Builder(name, (ObjectMapper.Builder)innerBuilder);
        }
        return new ArrayMapper.Builder(name, innerBuilder);
    }
}

