/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ArrayFieldType;
import org.elasticsearch.index.mapper.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;

public class ArrayMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "array";
    public static final String INNER_TYPE = "inner";
    private Mapper innerMapper;

    ArrayMapper(String simpleName, Integer position, @Nullable String defaultExpression, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, Mapper innerMapper) {
        super(simpleName, position, defaultExpression, fieldType, defaultFieldType, indexSettings, multiFields, FieldMapper.CopyTo.empty());
        this.innerMapper = innerMapper;
    }

    private static MappedFieldType newArrayFieldType(Mapper.Builder innerBuilder) {
        if (innerBuilder instanceof FieldMapper.Builder) {
            return new ArrayFieldType(((FieldMapper.Builder)innerBuilder).fieldType());
        }
        throw new IllegalArgumentException("expected a FieldMapper.Builder");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return ArrayMapper.toXContent(builder, params, this.innerMapper, this.simpleName(), this.contentType());
    }

    static XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, Mapper innerMapper, String name, String contentType) throws IOException {
        XContentBuilder innerBuilder = new XContentBuilder(builder.contentType().xContent(), new BytesStreamOutput(0));
        innerBuilder.startObject();
        innerBuilder = innerMapper.toXContent(innerBuilder, params);
        innerBuilder.endObject();
        innerBuilder.close();
        XContentParser parser = builder.contentType().xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, BytesReference.toBytes(BytesReference.bytes(innerBuilder)));
        while (parser.nextToken() != XContentParser.Token.START_OBJECT) {
        }
        Map innerMap = (Map)parser.mapOrdered().get(innerMapper.simpleName());
        assert (innerMap != null) : "innerMap was null";
        builder.startObject(name);
        builder.field("type", contentType);
        builder.field(INNER_TYPE, innerMap);
        return builder.endObject();
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.innerMapper.iterator();
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        this.innerMapper = mergeWith instanceof ArrayMapper ? this.innerMapper.merge(((ArrayMapper)mergeWith).innerMapper) : this.innerMapper.merge(mergeWith);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            this.parseInner(context);
            return;
        }
        if (token == XContentParser.Token.START_ARRAY) {
            token = parser.nextToken();
        }
        Mapper newInnerMapper = this.innerMapper;
        while (token != XContentParser.Token.END_ARRAY) {
            this.parseInner(context);
            token = parser.nextToken();
        }
        if (newInnerMapper == this.innerMapper) {
            return;
        }
        this.innerMapper = newInnerMapper;
    }

    private void parseInner(ParseContext context) throws IOException {
        assert (this.innerMapper instanceof FieldMapper) : "InnerMapper must be a FieldMapper";
        ((FieldMapper)this.innerMapper).parse(context);
        if (this.copyTo() != null) {
            DocumentParser.parseCopyFields(context, this.copyTo().copyToFields());
        }
    }

    @Override
    public FieldMapper.CopyTo copyTo() {
        if (this.innerMapper instanceof FieldMapper) {
            return ((FieldMapper)this.innerMapper).copyTo();
        }
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("parseCreateField not supported for " + ArrayMapper.class.getSimpleName());
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, ArrayMapper> {
        private final Mapper.Builder innerBuilder;

        public Builder(String name, Mapper.Builder innerBuilder) {
            super(name, ArrayMapper.newArrayFieldType(innerBuilder), ArrayMapper.newArrayFieldType(innerBuilder));
            this.innerBuilder = innerBuilder;
        }

        @Override
        public ArrayMapper build(Mapper.BuilderContext context) {
            Object innerMapper = this.innerBuilder.build(context);
            return new ArrayMapper(this.name, this.position, this.defaultExpression, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), (Mapper)innerMapper);
        }
    }
}

