/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.joda.time.DateTimeZone;

class ArrayFieldType
extends MappedFieldType
implements Cloneable {
    private final MappedFieldType innerFieldType;

    private ArrayFieldType(ArrayFieldType ref) {
        super(ref);
        this.innerFieldType = ref.innerFieldType;
    }

    ArrayFieldType(MappedFieldType innerFieldType) {
        this.innerFieldType = innerFieldType;
    }

    @Override
    public String name() {
        return this.innerFieldType.name();
    }

    @Override
    public MappedFieldType clone() {
        return new ArrayFieldType(this);
    }

    @Override
    public String typeName() {
        return "array";
    }

    @Override
    public void checkCompatibility(MappedFieldType other, List<String> conflicts) {
        super.checkCompatibility(other, conflicts);
        this.innerFieldType.checkCompatibility(((ArrayFieldType)other).innerFieldType, conflicts);
    }

    @Override
    public boolean hasDocValues() {
        return this.innerFieldType.hasDocValues();
    }

    @Override
    public void setHasDocValues(boolean hasDocValues) {
        this.innerFieldType.setHasDocValues(hasDocValues);
    }

    @Override
    public NamedAnalyzer indexAnalyzer() {
        return this.innerFieldType.indexAnalyzer();
    }

    @Override
    public void setIndexAnalyzer(NamedAnalyzer analyzer) {
        this.innerFieldType.setIndexAnalyzer(analyzer);
    }

    @Override
    public NamedAnalyzer searchAnalyzer() {
        return this.innerFieldType.searchAnalyzer();
    }

    @Override
    public void setSearchAnalyzer(NamedAnalyzer analyzer) {
        this.innerFieldType.setSearchAnalyzer(analyzer);
    }

    @Override
    public NamedAnalyzer searchQuoteAnalyzer() {
        return this.innerFieldType.searchQuoteAnalyzer();
    }

    @Override
    public void setSearchQuoteAnalyzer(NamedAnalyzer analyzer) {
        this.innerFieldType.setSearchQuoteAnalyzer(analyzer);
    }

    @Override
    public Object nullValue() {
        return this.innerFieldType.nullValue();
    }

    @Override
    public String nullValueAsString() {
        return this.innerFieldType.nullValueAsString();
    }

    @Override
    public void setNullValue(Object nullValue) {
        this.innerFieldType.setNullValue(nullValue);
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryShardContext context) {
        return this.innerFieldType.termQuery(value, context);
    }

    @Override
    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        return this.innerFieldType.termsQuery(values, context);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, DateTimeZone timeZone, QueryShardContext context) {
        return this.innerFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, context);
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        return this.innerFieldType.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions);
    }

    @Override
    public Query nullValueQuery() {
        return this.innerFieldType.nullValueQuery();
    }

    @Override
    @Nullable
    public Query queryStringTermQuery(Term term) {
        return this.innerFieldType.queryStringTermQuery(term);
    }

    @Override
    public Query existsQuery(QueryShardContext context) {
        return this.innerFieldType.existsQuery(context);
    }
}

