/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.nio.charset.StandardCharsets;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.mapper.Uid;

public class IDVisitor
extends StoredFieldVisitor {
    private boolean canStop = false;
    private String id;
    private final String columnName;

    public IDVisitor(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCanStop(boolean canStop) {
        this.canStop = canStop;
    }

    public boolean canStop() {
        return this.canStop;
    }

    public String getId() {
        return this.id;
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.canStop) {
            return StoredFieldVisitor.Status.STOP;
        }
        if (this.columnName.equals(fieldInfo.name)) {
            this.canStop = true;
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        assert (this.columnName.equals(fieldInfo.name)) : "binaryField must only be called for id";
        this.id = Uid.decodeId(value);
    }

    public void stringField(FieldInfo fieldInfo, byte[] value) {
        assert (this.columnName.equals(fieldInfo.name)) : "stringField must only be called for id";
        this.id = new String(value, StandardCharsets.UTF_8);
    }

    public void reset() {
        this.id = null;
        this.canStop = false;
    }
}

