/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;

public class FieldsVisitor
extends StoredFieldVisitor {
    private static final Set<String> BASE_REQUIRED_FIELDS = Set.of("_id", "_routing");
    private final boolean loadSource;
    private final String sourceFieldName;
    private final Set<String> requiredFields;
    protected BytesReference source;
    protected String id;
    protected Map<String, List<Object>> fieldsValues;

    public FieldsVisitor(boolean loadSource) {
        this(loadSource, "_source");
    }

    public FieldsVisitor(boolean loadSource, String sourceFieldName) {
        this.loadSource = loadSource;
        this.sourceFieldName = sourceFieldName;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (this.requiredFields.remove(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_ignored".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.requiredFields.isEmpty() ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    public void postProcess(MapperService mapperService) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            MappedFieldType fieldType = mapperService.fullName(entry.getKey());
            if (fieldType == null) {
                throw new IllegalStateException("Field [" + entry.getKey() + "] exists in the index but not in mappings");
            }
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
            }
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if (this.sourceFieldName.equals(fieldInfo.name)) {
            this.source = new BytesArray(value);
        } else if ("_id".equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value);
        } else {
            this.addValue(fieldInfo.name, new BytesRef(value));
        }
    }

    public void stringField(FieldInfo fieldInfo, byte[] bytes) throws IOException {
        String value = new String(bytes, StandardCharsets.UTF_8);
        this.addValue(fieldInfo.name, value);
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public BytesReference source() {
        return this.source;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        if (this.fieldsValues == null) {
            return null;
        }
        List<Object> values = this.fieldsValues.get("_routing");
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.get(0).toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : Collections.emptyMap();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.id = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add(this.sourceFieldName);
        }
    }

    void addValue(String name, Object value) {
        List<Object> values;
        if (this.fieldsValues == null) {
            this.fieldsValues = new HashMap<String, List<Object>>();
        }
        if ((values = this.fieldsValues.get(name)) == null) {
            values = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values);
        }
        values.add(value);
    }
}

