/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SingletonSortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SingletonSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;

public final class FieldData
extends Enum<FieldData> {
    private static final /* synthetic */ FieldData[] $VALUES;

    public static FieldData[] values() {
        return (FieldData[])$VALUES.clone();
    }

    public static FieldData valueOf(String name) {
        return Enum.valueOf(FieldData.class, name);
    }

    public static SortedNumericDoubleValues sortableLongBitsToDoubles(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return FieldData.singleton(new SortableLongBitsToNumericDoubleValues(singleton));
        }
        return new SortableLongBitsToSortedNumericDoubleValues(values);
    }

    public static SortedNumericDoubleValues singleton(NumericDoubleValues values) {
        return new SingletonSortedNumericDoubleValues(values);
    }

    public static SortedBinaryDocValues singleton(BinaryDocValues values) {
        return new SingletonSortedBinaryDocValues(values);
    }

    public static SortedBinaryDocValues toString(final SortedNumericDocValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Long.toString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedNumericDoubleValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Double.toString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedSetDocValues values) {
        return new SortedBinaryDocValues(){
            private int count = 0;

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (!values.advanceExact(doc)) {
                    return false;
                }
                int i = 0;
                while (true) {
                    if (values.nextOrd() == -1L) break;
                    ++i;
                }
                this.count = i;
                boolean advanced = values.advanceExact(doc);
                assert (advanced);
                return true;
            }

            @Override
            public int docValueCount() {
                return this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                return values.lookupOrd(values.nextOrd());
            }
        };
    }

    private static SortedBinaryDocValues toString(final ToStringValues toStringValues) {
        return new SortingBinaryDocValues(){
            final List<CharSequence> list = new ArrayList<CharSequence>();

            @Override
            public boolean advanceExact(int docID) throws IOException {
                if (!toStringValues.advanceExact(docID)) {
                    return false;
                }
                this.list.clear();
                toStringValues.get(this.list);
                this.count = this.list.size();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    CharSequence s = this.list.get(i);
                    this.values[i].copyChars(s);
                }
                this.sort();
                return true;
            }
        };
    }

    private static /* synthetic */ FieldData[] $values() {
        return new FieldData[0];
    }

    static {
        $VALUES = FieldData.$values();
    }

    private static interface ToStringValues {
        public boolean advanceExact(int var1) throws IOException;

        public void get(List<CharSequence> var1) throws IOException;
    }
}

