/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.unit.ByteSizeValue;

public class Segment {
    private String name;
    private long generation;
    public boolean committed;
    public boolean search;
    public long sizeInBytes = -1L;
    public int docCount = -1;
    public int delDocCount = -1;
    public Version version = null;
    public Boolean compound = null;
    public String mergeId;
    public long memoryInBytes;
    public Sort segmentSort;
    public Accountable ramTree = null;
    public Map<String, String> attributes;

    public Segment(String name) {
        this.name = name;
        this.generation = Long.parseLong(name.substring(1), 36);
    }

    public String getName() {
        return this.name;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isSearch() {
        return this.search;
    }

    public int getNumDocs() {
        return this.docCount;
    }

    public int getDeletedDocs() {
        return this.delDocCount;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    @Nullable
    public String getMergeId() {
        return this.mergeId;
    }

    public Version getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean isCompound() {
        return this.compound;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return Objects.equals(this.name, segment.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "Segment{name='" + this.name + "', generation=" + this.generation + ", committed=" + this.committed + ", search=" + this.search + ", sizeInBytes=" + this.sizeInBytes + ", docCount=" + this.docCount + ", delDocCount=" + this.delDocCount + ", version='" + this.version + "', compound=" + this.compound + ", mergeId='" + this.mergeId + "', memoryInBytes=" + this.memoryInBytes + (String)(this.segmentSort != null ? ", sort=" + this.segmentSort : "") + ", attributes=" + this.attributes + "}";
    }
}

