/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class QueryCacheStats
implements Writeable {
    private long ramBytesUsed;
    private long hitCount;
    private long missCount;
    private long cacheCount;
    private long cacheSize;

    public QueryCacheStats() {
    }

    public QueryCacheStats(long ramBytesUsed, long hitCount, long missCount, long cacheCount, long cacheSize) {
        this.ramBytesUsed = ramBytesUsed;
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.cacheCount = cacheCount;
        this.cacheSize = cacheSize;
    }

    public QueryCacheStats(StreamInput in) throws IOException {
        this.ramBytesUsed = in.readLong();
        this.hitCount = in.readLong();
        this.missCount = in.readLong();
        this.cacheCount = in.readLong();
        this.cacheSize = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.ramBytesUsed);
        out.writeLong(this.hitCount);
        out.writeLong(this.missCount);
        out.writeLong(this.cacheCount);
        out.writeLong(this.cacheSize);
    }

    public void add(QueryCacheStats stats) {
        this.ramBytesUsed += stats.ramBytesUsed;
        this.hitCount += stats.hitCount;
        this.missCount += stats.missCount;
        this.cacheCount += stats.cacheCount;
        this.cacheSize += stats.cacheSize;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

