/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import io.crate.common.unit.TimeValue;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.node.Node;

public final class IndexSettings {
    public static final String DEFAULT_FIELD_SETTING_KEY = "index.query.default_field";
    public static final Setting<List<String>> DEFAULT_FIELD_SETTING;
    public static final Setting<Boolean> ALLOW_UNMAPPED;
    public static final Setting<TimeValue> INDEX_TRANSLOG_SYNC_INTERVAL_SETTING;
    public static final Setting<TimeValue> INDEX_SEARCH_IDLE_AFTER;
    public static final Setting<Translog.Durability> INDEX_TRANSLOG_DURABILITY_SETTING;
    public static final Setting<Boolean> INDEX_WARMER_ENABLED_SETTING;
    public static final Setting<String> INDEX_CHECK_ON_STARTUP;
    public static final Setting<Integer> MAX_NGRAM_DIFF_SETTING;
    public static final Setting<Integer> MAX_SHINGLE_DIFF_SETTING;
    public static final TimeValue DEFAULT_REFRESH_INTERVAL;
    public static final Setting<TimeValue> INDEX_REFRESH_INTERVAL_SETTING;
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING;
    public static final Setting<ByteSizeValue> INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING;
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING;
    public static final TimeValue DEFAULT_GC_DELETES;
    public static final Setting<TimeValue> INDEX_GC_DELETES_SETTING;
    public static final Setting<Boolean> INDEX_SOFT_DELETES_SETTING;
    public static final Setting<Long> INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING;
    public static final Setting<TimeValue> INDEX_TRANSLOG_RETENTION_AGE_SETTING;
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_RETENTION_SIZE_SETTING;
    public static final Setting<Integer> INDEX_TRANSLOG_RETENTION_TOTAL_FILES_SETTING;
    public static final Setting<TimeValue> INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING;
    public static final Setting<Integer> MAX_REFRESH_LISTENERS_PER_SHARD;
    public static final String INDEX_MAPPING_SINGLE_TYPE_SETTING_KEY = "index.mapping.single_type";
    private static final Setting<Boolean> INDEX_MAPPING_SINGLE_TYPE_SETTING;
    public static final Setting<Double> FILE_BASED_RECOVERY_THRESHOLD_SETTING;
    private final Index index;
    private final Version version;
    private final Logger logger;
    private final String nodeName;
    private final Settings nodeSettings;
    private final int numberOfShards;
    private volatile Settings settings;
    private volatile IndexMetadata indexMetadata;
    private volatile List<String> defaultFields;
    private final boolean defaultAllowUnmappedFields;
    private volatile Translog.Durability durability;
    private volatile TimeValue syncInterval;
    private volatile TimeValue refreshInterval;
    private volatile ByteSizeValue flushThresholdSize;
    private volatile TimeValue translogRetentionAge;
    private volatile ByteSizeValue translogRetentionSize;
    private volatile ByteSizeValue flushAfterMergeThresholdSize;
    private volatile ByteSizeValue generationThresholdSize;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final MergePolicyConfig mergePolicyConfig;
    private final IndexScopedSettings scopedSettings;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private final boolean softDeleteEnabled;
    private volatile long softDeleteRetentionOperations;
    private volatile long retentionLeaseMillis;
    private volatile boolean warmerEnabled;
    private volatile int maxNgramDiff;
    private volatile int maxShingleDiff;
    private volatile TimeValue searchIdleAfter;
    private volatile int maxRefreshListeners;
    private final boolean singleType;

    public long getRetentionLeaseMillis() {
        return this.retentionLeaseMillis;
    }

    private void setRetentionLeaseMillis(TimeValue retentionLease) {
        this.retentionLeaseMillis = retentionLease.millis();
    }

    public List<String> getDefaultFields() {
        return this.defaultFields;
    }

    private void setDefaultFields(List<String> defaultFields) {
        this.defaultFields = defaultFields;
    }

    public boolean isDefaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public IndexSettings(IndexMetadata indexMetadata, Settings nodeSettings) {
        this(indexMetadata, nodeSettings, IndexScopedSettings.DEFAULT_SCOPED_SETTINGS);
    }

    public IndexSettings(IndexMetadata indexMetadata, Settings nodeSettings, IndexScopedSettings indexScopedSettings) {
        this.scopedSettings = indexScopedSettings.copy(nodeSettings, indexMetadata);
        this.nodeSettings = nodeSettings;
        this.settings = Settings.builder().put(nodeSettings).put(indexMetadata.getSettings()).build();
        this.index = indexMetadata.getIndex();
        this.version = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(this.settings);
        this.logger = Loggers.getLogger(this.getClass(), this.index, new String[0]);
        this.nodeName = Node.NODE_NAME_SETTING.get(this.settings);
        this.indexMetadata = indexMetadata;
        this.numberOfShards = this.settings.getAsInt("index.number_of_shards", null);
        this.defaultAllowUnmappedFields = this.scopedSettings.get(ALLOW_UNMAPPED);
        this.durability = this.scopedSettings.get(INDEX_TRANSLOG_DURABILITY_SETTING);
        this.defaultFields = this.scopedSettings.get(DEFAULT_FIELD_SETTING);
        this.syncInterval = INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.get(this.settings);
        this.refreshInterval = this.scopedSettings.get(INDEX_REFRESH_INTERVAL_SETTING);
        this.flushThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING);
        this.generationThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING);
        this.flushAfterMergeThresholdSize = this.scopedSettings.get(INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING);
        this.mergeSchedulerConfig = new MergeSchedulerConfig(this);
        this.gcDeletesInMillis = this.scopedSettings.get(INDEX_GC_DELETES_SETTING).getMillis();
        this.softDeleteEnabled = this.version.onOrAfter(Version.V_3_2_0) && this.scopedSettings.get(INDEX_SOFT_DELETES_SETTING) != false;
        this.softDeleteRetentionOperations = this.scopedSettings.get(INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING);
        this.retentionLeaseMillis = this.scopedSettings.get(INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING).millis();
        this.warmerEnabled = this.scopedSettings.get(INDEX_WARMER_ENABLED_SETTING);
        this.maxNgramDiff = this.scopedSettings.get(MAX_NGRAM_DIFF_SETTING);
        this.maxShingleDiff = this.scopedSettings.get(MAX_SHINGLE_DIFF_SETTING);
        this.maxRefreshListeners = this.scopedSettings.get(MAX_REFRESH_LISTENERS_PER_SHARD);
        this.mergePolicyConfig = new MergePolicyConfig(this.logger, this);
        this.searchIdleAfter = this.scopedSettings.get(INDEX_SEARCH_IDLE_AFTER);
        this.setTranslogRetentionAge(this.scopedSettings.get(INDEX_TRANSLOG_RETENTION_AGE_SETTING));
        this.setTranslogRetentionSize(this.scopedSettings.get(INDEX_TRANSLOG_RETENTION_SIZE_SETTING));
        this.singleType = INDEX_MAPPING_SINGLE_TYPE_SETTING.get(indexMetadata.getSettings());
        if (!this.singleType) {
            throw new AssertionError((Object)(this.index.toString() + "multiple types are only allowed on pre 6.x indices but version is: [" + this.version + "]"));
        }
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING, this.mergePolicyConfig::setNoCFSRatio);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING, this.mergePolicyConfig::setDeletesPctAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING, this.mergePolicyConfig::setExpungeDeletesAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING, this.mergePolicyConfig::setFloorSegmentSetting);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING, this.mergePolicyConfig::setMaxMergesAtOnce);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING, this.mergePolicyConfig::setMaxMergesAtOnceExplicit);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING, this.mergePolicyConfig::setMaxMergedSegment);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING, this.mergePolicyConfig::setSegmentsPerTier);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING, this.mergeSchedulerConfig::setMaxThreadAndMergeCount);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.AUTO_THROTTLE_SETTING, this.mergeSchedulerConfig::setAutoThrottle);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_DURABILITY_SETTING, this::setTranslogDurability);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_SYNC_INTERVAL_SETTING, this::setTranslogSyncInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_NGRAM_DIFF_SETTING, this::setMaxNgramDiff);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SHINGLE_DIFF_SETTING, this::setMaxShingleDiff);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_WARMER_ENABLED_SETTING, this::setEnableWarmer);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_GC_DELETES_SETTING, this::setGCDeletes);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, this::setTranslogFlushThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING, this::setFlushAfterMergeThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING, this::setGenerationThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_RETENTION_AGE_SETTING, this::setTranslogRetentionAge);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_RETENTION_SIZE_SETTING, this::setTranslogRetentionSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REFRESH_LISTENERS_PER_SHARD, this::setMaxRefreshListeners);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_FIELD_SETTING, this::setDefaultFields);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SEARCH_IDLE_AFTER, this::setSearchIdleAfter);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING, this::setSoftDeleteRetentionOperations);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING, this::setRetentionLeaseMillis);
    }

    private void setSearchIdleAfter(TimeValue searchIdleAfter) {
        this.searchIdleAfter = searchIdleAfter;
    }

    private void setTranslogFlushThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushThresholdSize = byteSizeValue;
    }

    private void setFlushAfterMergeThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushAfterMergeThresholdSize = byteSizeValue;
    }

    private void setTranslogRetentionSize(ByteSizeValue byteSizeValue) {
        this.translogRetentionSize = this.softDeleteEnabled && byteSizeValue.getBytes() >= 0L ? new ByteSizeValue(-1L) : byteSizeValue;
    }

    private void setTranslogRetentionAge(TimeValue age) {
        this.translogRetentionAge = this.softDeleteEnabled && age.millis() >= 0L ? TimeValue.MINUS_ONE : age;
    }

    private void setGenerationThresholdSize(ByteSizeValue generationThresholdSize) {
        this.generationThresholdSize = generationThresholdSize;
    }

    private void setGCDeletes(TimeValue timeValue) {
        this.gcDeletesInMillis = timeValue.getMillis();
    }

    private void setRefreshInterval(TimeValue timeValue) {
        this.refreshInterval = timeValue;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getUUID() {
        return this.getIndex().getUUID();
    }

    public boolean hasCustomDataPath() {
        return this.customDataPath() != null;
    }

    public String customDataPath() {
        return this.settings.get("index.data_path");
    }

    public Version getIndexVersionCreated() {
        return this.version;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.settings.getAsInt("index.number_of_replicas", null);
    }

    public Settings getNodeSettings() {
        return this.nodeSettings;
    }

    public synchronized boolean updateIndexMetadata(IndexMetadata indexMetadata) {
        Settings newSettings = indexMetadata.getSettings();
        if (!this.version.equals(Version.indexCreated(newSettings))) {
            throw new IllegalArgumentException("version mismatch on settings update expected: " + this.version + " but was: " + Version.indexCreated(newSettings));
        }
        String newUUID = newSettings.get("index.uuid", "_na_");
        if (!newUUID.equals(this.getUUID())) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + this.getUUID() + " but was: " + newUUID);
        }
        this.indexMetadata = indexMetadata;
        Settings newIndexSettings = Settings.builder().put(this.nodeSettings).put(newSettings).build();
        if (IndexSettings.same(this.settings, newIndexSettings)) {
            return false;
        }
        this.scopedSettings.applySettings(newSettings);
        this.settings = newIndexSettings;
        return true;
    }

    public static boolean same(Settings left, Settings right) {
        return left.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE).equals(right.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE));
    }

    public Translog.Durability getTranslogDurability() {
        return this.durability;
    }

    private void setTranslogDurability(Translog.Durability durability) {
        this.durability = durability;
    }

    public boolean isWarmerEnabled() {
        return this.warmerEnabled;
    }

    private void setEnableWarmer(boolean enableWarmer) {
        this.warmerEnabled = enableWarmer;
    }

    public TimeValue getTranslogSyncInterval() {
        return this.syncInterval;
    }

    public void setTranslogSyncInterval(TimeValue translogSyncInterval) {
        this.syncInterval = translogSyncInterval;
    }

    public TimeValue getRefreshInterval() {
        return this.refreshInterval;
    }

    public ByteSizeValue getFlushThresholdSize() {
        return this.flushThresholdSize;
    }

    public ByteSizeValue getFlushAfterMergeThresholdSize() {
        return this.flushAfterMergeThresholdSize;
    }

    public ByteSizeValue getTranslogRetentionSize() {
        assert (!this.softDeleteEnabled || this.translogRetentionSize.getBytes() == -1L) : this.translogRetentionSize;
        return this.translogRetentionSize;
    }

    public TimeValue getTranslogRetentionAge() {
        assert (!this.softDeleteEnabled || this.translogRetentionAge.millis() == -1L) : this.translogRetentionSize;
        return this.translogRetentionAge;
    }

    public int getTranslogRetentionTotalFiles() {
        return INDEX_TRANSLOG_RETENTION_TOTAL_FILES_SETTING.get(this.getSettings());
    }

    public ByteSizeValue getGenerationThresholdSize() {
        return this.generationThresholdSize;
    }

    public MergeSchedulerConfig getMergeSchedulerConfig() {
        return this.mergeSchedulerConfig;
    }

    public int getMaxNgramDiff() {
        return this.maxNgramDiff;
    }

    private void setMaxNgramDiff(int maxNgramDiff) {
        this.maxNgramDiff = maxNgramDiff;
    }

    public int getMaxShingleDiff() {
        return this.maxShingleDiff;
    }

    private void setMaxShingleDiff(int maxShingleDiff) {
        this.maxShingleDiff = maxShingleDiff;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicyConfig.getMergePolicy();
    }

    public <T> T getValue(Setting<T> setting) {
        return this.scopedSettings.get(setting);
    }

    public int getMaxRefreshListeners() {
        return this.maxRefreshListeners;
    }

    private void setMaxRefreshListeners(int maxRefreshListeners) {
        this.maxRefreshListeners = maxRefreshListeners;
    }

    public IndexScopedSettings getScopedSettings() {
        return this.scopedSettings;
    }

    public boolean isExplicitRefresh() {
        return INDEX_REFRESH_INTERVAL_SETTING.exists(this.settings);
    }

    public TimeValue getSearchIdleAfter() {
        return this.searchIdleAfter;
    }

    public boolean isSoftDeleteEnabled() {
        return this.softDeleteEnabled;
    }

    private void setSoftDeleteRetentionOperations(long ops) {
        this.softDeleteRetentionOperations = ops;
    }

    public long getSoftDeleteRetentionOperations() {
        return this.softDeleteRetentionOperations;
    }

    static {
        Function<Settings, List<String>> defValue = settings -> {
            String defaultField = "*";
            return Collections.singletonList("*");
        };
        DEFAULT_FIELD_SETTING = Setting.listSetting(DEFAULT_FIELD_SETTING_KEY, Function.identity(), defValue, Setting.Property.Dynamic, Setting.Property.IndexScope);
        ALLOW_UNMAPPED = Setting.boolSetting("index.query.parse.allow_unmapped_fields", true, Setting.Property.IndexScope);
        INDEX_TRANSLOG_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.translog.sync_interval", TimeValue.timeValueSeconds(5L), TimeValue.timeValueMillis(100L), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_SEARCH_IDLE_AFTER = Setting.timeSetting("index.search.idle.after", TimeValue.timeValueSeconds(30L), TimeValue.timeValueMinutes(0L), Setting.Property.IndexScope, Setting.Property.Dynamic);
        INDEX_TRANSLOG_DURABILITY_SETTING = new Setting<Translog.Durability>("index.translog.durability", Translog.Durability.REQUEST.name(), value -> Translog.Durability.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_WARMER_ENABLED_SETTING = Setting.boolSetting("index.warmer.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
        INDEX_CHECK_ON_STARTUP = new Setting<String>("index.shard.check_on_startup", "false", s -> {
            switch (s) {
                case "false": 
                case "true": 
                case "fix": 
                case "checksum": {
                    return s;
                }
            }
            throw new IllegalArgumentException("unknown value for [index.shard.check_on_startup] must be one of [true, false, fix, checksum] but was: " + s);
        }, Setting.Property.IndexScope);
        MAX_NGRAM_DIFF_SETTING = Setting.intSetting("index.max_ngram_diff", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_SHINGLE_DIFF_SETTING = Setting.intSetting("index.max_shingle_diff", 3, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
        INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.refresh_interval", DEFAULT_REFRESH_INTERVAL, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.flush_threshold_size", new ByteSizeValue(512L, ByteSizeUnit.MB), new ByteSizeValue(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.flush_after_merge", new ByteSizeValue(512L, ByteSizeUnit.MB), new ByteSizeValue(0L, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.generation_threshold_size", new ByteSizeValue(64L, ByteSizeUnit.MB), new ByteSizeValue(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
        DEFAULT_GC_DELETES = TimeValue.timeValueSeconds(60L);
        INDEX_GC_DELETES_SETTING = Setting.timeSetting("index.gc_deletes", DEFAULT_GC_DELETES, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_SOFT_DELETES_SETTING = Setting.boolSetting("index.soft_deletes.enabled", settings -> Boolean.toString(IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings).onOrAfter(Version.V_4_3_0)), Setting.Property.IndexScope, Setting.Property.Final);
        INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING = Setting.longSetting("index.soft_deletes.retention.operations", 0L, 0L, Setting.Property.IndexScope, Setting.Property.Dynamic);
        INDEX_TRANSLOG_RETENTION_AGE_SETTING = Setting.timeSetting("index.translog.retention.age", TimeValue.timeValueHours(12L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_RETENTION_SIZE_SETTING = Setting.byteSizeSetting("index.translog.retention.size", new ByteSizeValue(512L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_RETENTION_TOTAL_FILES_SETTING = Setting.intSetting("index.translog.retention.total_files", 100, 0, Setting.Property.IndexScope);
        INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING = Setting.timeSetting("index.soft_deletes.retention_lease.period", TimeValue.timeValueHours(12L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_REFRESH_LISTENERS_PER_SHARD = Setting.intSetting("index.max_refresh_listeners", 1000, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_MAPPING_SINGLE_TYPE_SETTING = Setting.boolSetting(INDEX_MAPPING_SINGLE_TYPE_SETTING_KEY, true, Setting.Property.IndexScope, Setting.Property.Final);
        FILE_BASED_RECOVERY_THRESHOLD_SETTING = Setting.doubleSetting("index.recovery.file_based_threshold", 0.1, 0.0, Setting.Property.IndexScope);
    }
}

