/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.MapBuilder;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.elasticsearch.Assertions;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexService
extends AbstractIndexComponent
implements IndicesClusterStateService.AllocatedIndex<IndexShard> {
    private final IndexEventListener eventListener;
    private final NodeEnvironment nodeEnv;
    private final ShardStoreDeleter shardStoreDeleter;
    private final IndexCache indexCache;
    private final IndexStorePlugin.DirectoryFactory directoryFactory;
    private final MapperService mapperService;
    private final NamedXContentRegistry xContentRegistry;
    private final EngineFactory engineFactory;
    private volatile Map<Integer, IndexShard> shards = Collections.emptyMap();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);
    private final IndexSettings indexSettings;
    private final List<IndexingOperationListener> indexingOperationListeners;
    private volatile AsyncRefreshTask refreshTask;
    private volatile AsyncTranslogFSync fsyncTask;
    private volatile AsyncGlobalCheckpointTask globalCheckpointTask;
    private volatile AsyncRetentionLeaseSyncTask retentionLeaseSyncTask;
    public static final String INDEX_TRANSLOG_RETENTION_CHECK_INTERVAL_SETTING = "index.translog.retention.check_interval";
    private final AsyncTrimTranslogTask trimTranslogTask;
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private final CircuitBreakerService circuitBreakerService;
    public static final Setting<TimeValue> GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.global_checkpoint_sync.interval", new TimeValue(30L, TimeUnit.SECONDS), new TimeValue(0L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> RETENTION_LEASE_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.soft_deletes.retention_lease.sync_interval", new TimeValue(5L, TimeUnit.MINUTES), new TimeValue(0L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);

    public IndexService(IndexSettings indexSettings, IndexCreationContext indexCreationContext, NodeEnvironment nodeEnv, NamedXContentRegistry xContentRegistry, ShardStoreDeleter shardStoreDeleter, AnalysisRegistry registry, EngineFactory engineFactory, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, QueryCache queryCache, IndexStorePlugin.DirectoryFactory directoryFactory, IndexEventListener eventListener, MapperRegistry mapperRegistry, List<IndexingOperationListener> indexingOperationListeners) throws IOException {
        super(indexSettings);
        this.indexSettings = indexSettings;
        this.xContentRegistry = xContentRegistry;
        this.circuitBreakerService = circuitBreakerService;
        if (indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE && indexCreationContext == IndexCreationContext.CREATE_INDEX) {
            this.mapperService = null;
            this.indexCache = null;
        } else {
            this.mapperService = new MapperService(indexSettings, registry.build(indexSettings), xContentRegistry, mapperRegistry, this::newQueryShardContext);
            this.indexCache = new IndexCache(indexSettings, queryCache);
        }
        this.shardStoreDeleter = shardStoreDeleter;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.eventListener = eventListener;
        this.nodeEnv = nodeEnv;
        this.directoryFactory = directoryFactory;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.indexingOperationListeners = Collections.unmodifiableList(indexingOperationListeners);
        this.refreshTask = new AsyncRefreshTask(this);
        this.trimTranslogTask = new AsyncTrimTranslogTask(this);
        this.globalCheckpointTask = new AsyncGlobalCheckpointTask(this);
        this.retentionLeaseSyncTask = new AsyncRetentionLeaseSyncTask(this);
        this.updateFsyncTaskIfNecessary();
    }

    public int numberOfShards() {
        return this.shards.size();
    }

    public IndexEventListener getIndexEventListener() {
        return this.eventListener;
    }

    @Override
    public Iterator<IndexShard> iterator() {
        return this.shards.values().iterator();
    }

    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    @Override
    @Nullable
    public IndexShard getShardOrNull(int shardId) {
        return this.shards.get(shardId);
    }

    public IndexShard getShard(int shardId) {
        IndexShard indexShard = this.getShardOrNull(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(this.index(), shardId));
        }
        return indexShard;
    }

    public Set<Integer> shardIds() {
        return this.shards.keySet();
    }

    public IndexCache cache() {
        return this.indexCache;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public NamedXContentRegistry xContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(String reason, boolean delete) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.deleted.compareAndSet(false, delete);
            try {
                Set<Integer> shardIds = this.shardIds();
                for (int shardId : shardIds) {
                    try {
                        this.removeShard(shardId, reason);
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to close shard", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(this.indexCache, this.mapperService, this.refreshTask, this.fsyncTask, this.trimTranslogTask, this.globalCheckpointTask, this.retentionLeaseSyncTask);
                throw throwable;
            }
            IOUtils.close(this.indexCache, this.mapperService, this.refreshTask, this.fsyncTask, this.trimTranslogTask, this.globalCheckpointTask, this.retentionLeaseSyncTask);
        }
    }

    public String indexUUID() {
        return this.indexSettings.getUUID();
    }

    private long getAvgShardSizeInBytes() throws IOException {
        long sum = 0L;
        int count = 0;
        for (IndexShard indexShard : this) {
            sum += indexShard.store().stats().sizeInBytes();
            ++count;
        }
        if (count == 0) {
            return -1L;
        }
        return sum / (long)count;
    }

    public synchronized IndexShard createShard(ShardRouting routing, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer) throws IOException {
        IndexShard indexShard;
        block16: {
            IndexShard indexShard2;
            Store store;
            ShardId shardId;
            block17: {
                Objects.requireNonNull(retentionLeaseSyncer);
                if (this.closed.get()) {
                    throw new IllegalStateException("Can't create shard " + routing.shardId() + ", closed");
                }
                Settings indexSettings = this.indexSettings.getSettings();
                shardId = routing.shardId();
                boolean success = false;
                store = null;
                indexShard2 = null;
                ShardLock lock = null;
                try {
                    ShardPath path;
                    lock = this.nodeEnv.shardLock(shardId, "starting shard", TimeUnit.SECONDS.toMillis(5L));
                    this.eventListener.beforeIndexShardCreated(shardId, indexSettings);
                    try {
                        path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, this.indexSettings);
                    }
                    catch (IllegalStateException ex) {
                        this.logger.warn("{} failed to load shard path, trying to remove leftover", (Object)shardId);
                        try {
                            ShardPath.deleteLeftoverShardDirectory(this.logger, this.nodeEnv, lock, this.indexSettings);
                            path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, this.indexSettings);
                        }
                        catch (Exception inner) {
                            ex.addSuppressed(inner);
                            throw ex;
                        }
                    }
                    if (path == null) {
                        HashMap<Path, Integer> dataPathToShardCount = new HashMap<Path, Integer>();
                        for (IndexShard shard : this) {
                            Path dataPath = shard.shardPath().getRootStatePath();
                            Integer curCount = (Integer)dataPathToShardCount.get(dataPath);
                            if (curCount == null) {
                                curCount = 0;
                            }
                            dataPathToShardCount.put(dataPath, curCount + 1);
                        }
                        path = ShardPath.selectNewPathForShard(this.nodeEnv, shardId, this.indexSettings, routing.getExpectedShardSize() == -1L ? this.getAvgShardSizeInBytes() : routing.getExpectedShardSize(), dataPathToShardCount);
                        this.logger.debug("{} creating using a new path [{}]", (Object)shardId, (Object)path);
                    } else {
                        this.logger.debug("{} creating using an existing path [{}]", (Object)shardId, (Object)path);
                    }
                    if (this.shards.containsKey(shardId.id())) {
                        throw new IllegalStateException(shardId + " already exists");
                    }
                    this.logger.debug("creating shard_id {}", (Object)shardId);
                    Directory directory = this.directoryFactory.newDirectory(this.indexSettings, path);
                    store = new Store(shardId, this.indexSettings, directory, lock, new StoreCloseListener(shardId, () -> this.eventListener.onStoreClosed(shardId)));
                    this.eventListener.onStoreCreated(shardId);
                    indexShard2 = new IndexShard(routing, this.indexSettings, path, store, this.indexCache, this.mapperService, this.engineFactory, this.eventListener, this.threadPool, this.bigArrays, this.indexingOperationListeners, () -> globalCheckpointSyncer.accept(shardId), retentionLeaseSyncer, this.circuitBreakerService);
                    this.eventListener.indexShardStateChanged(indexShard2, null, indexShard2.state(), "shard created");
                    this.eventListener.afterIndexShardCreated(indexShard2);
                    this.shards = MapBuilder.newMapBuilder(this.shards).put(shardId.id(), indexShard2).immutableMap();
                    success = true;
                    indexShard = indexShard2;
                    if (success) break block16;
                    if (lock == null) break block17;
                }
                catch (ShardLockObtainFailedException e) {
                    try {
                        throw new IOException("failed to obtain in-memory shard lock", e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            if (lock != null) {
                                IOUtils.closeWhileHandlingException(lock);
                            }
                            this.closeShard("initialization failed", shardId, indexShard2, store, this.eventListener);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeWhileHandlingException(lock);
            }
            this.closeShard("initialization failed", shardId, indexShard2, store, this.eventListener);
        }
        return indexShard;
    }

    @Override
    public synchronized void removeShard(int shardId, String reason) {
        ShardId sId = new ShardId(this.index(), shardId);
        if (!this.shards.containsKey(shardId)) {
            return;
        }
        this.logger.debug("[{}] closing... (reason: [{}])", (Object)shardId, (Object)reason);
        HashMap<Integer, IndexShard> newShards = new HashMap<Integer, IndexShard>(this.shards);
        IndexShard indexShard = newShards.remove(shardId);
        this.shards = Collections.unmodifiableMap(newShards);
        this.closeShard(reason, sId, indexShard, indexShard.store(), indexShard.getIndexEventListener());
        this.logger.debug("[{}] closed (reason: [{}])", (Object)shardId, (Object)reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeShard(String reason, ShardId sId, IndexShard indexShard, Store store, IndexEventListener listener) {
        int shardId = sId.id();
        Settings indexSettings = this.getIndexSettings().getSettings();
        if (store != null) {
            store.beforeClose();
        }
        try {
            block17: {
                try {
                    listener.beforeIndexShardClosed(sId, indexShard, indexSettings);
                    if (indexShard == null) break block17;
                }
                catch (Throwable throwable) {
                    if (indexShard != null) {
                        try {
                            boolean flushEngine = !this.deleted.get() && this.closed.get();
                            indexShard.close(reason, flushEngine);
                        }
                        catch (Exception e) {
                            this.logger.debug(() -> new ParameterizedMessage("[{}] failed to close index shard", (Object)shardId), (Throwable)e);
                        }
                    }
                    listener.afterIndexShardClosed(sId, indexShard, indexSettings);
                    throw throwable;
                }
                try {
                    boolean flushEngine = !this.deleted.get() && this.closed.get();
                    indexShard.close(reason, flushEngine);
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("[{}] failed to close index shard", (Object)shardId), (Throwable)e);
                }
            }
            listener.afterIndexShardClosed(sId, indexShard, indexSettings);
        }
        finally {
            try {
                if (store != null) {
                    store.close();
                } else {
                    this.logger.trace("[{}] store not initialized prior to closing shard, nothing to close", (Object)shardId);
                }
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to close store on shard removal (reason: [{}])", (Object)shardId, (Object)reason), (Throwable)e);
            }
        }
    }

    private void onShardClose(ShardLock lock) {
        if (this.deleted.get()) {
            try {
                try {
                    this.eventListener.beforeIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                }
                finally {
                    this.shardStoreDeleter.deleteShardStore("delete index", lock, this.indexSettings);
                    this.eventListener.afterIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                }
            }
            catch (IOException e) {
                this.shardStoreDeleter.addPendingDelete(lock.getShardId(), this.indexSettings);
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to delete shard content - scheduled a retry", (Object)lock.getShardId().id()), (Throwable)e);
            }
        }
    }

    @Override
    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public QueryShardContext newQueryShardContext() {
        return new QueryShardContext(this.indexSettings, this.mapperService());
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    @Override
    public boolean updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        if (this.mapperService == null) {
            return false;
        }
        return this.mapperService.updateMapping(currentIndexMetadata, newIndexMetadata);
    }

    public IndexMetadata getMetadata() {
        return this.indexSettings.getIndexMetadata();
    }

    @Override
    public synchronized void updateMetadata(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
        boolean updateIndexMetadata = this.indexSettings.updateIndexMetadata(newIndexMetadata);
        if (Assertions.ENABLED && currentIndexMetadata != null && currentIndexMetadata.getCreationVersion().onOrAfter(Version.V_3_2_0)) {
            long newSettingsVersion;
            long currentSettingsVersion = currentIndexMetadata.getSettingsVersion();
            if (currentSettingsVersion == (newSettingsVersion = newIndexMetadata.getSettingsVersion())) {
                assert (!updateIndexMetadata);
            } else {
                assert (updateIndexMetadata);
                assert (currentSettingsVersion < newSettingsVersion) : "expected current settings version [" + currentSettingsVersion + "] to be less than new settings version [" + newSettingsVersion + "]";
            }
        }
        if (updateIndexMetadata) {
            for (IndexShard shard : this.shards.values()) {
                try {
                    shard.onSettingsChanged();
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("[{}] failed to notify shard about setting change", (Object)shard.shardId().id()), (Throwable)e);
                }
            }
            if (!this.refreshTask.getInterval().equals(this.indexSettings.getRefreshInterval())) {
                this.threadPool.executor("refresh").execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        IndexService.this.logger.warn("forced refresh failed after interval change", (Throwable)e);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        IndexService.this.maybeRefreshEngine(true);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return true;
                    }
                });
                this.rescheduleRefreshTasks();
            }
            this.updateFsyncTaskIfNecessary();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFsyncTaskIfNecessary() {
        if (this.indexSettings.getTranslogDurability() == Translog.Durability.REQUEST) {
            try {
                if (this.fsyncTask == null) return;
                this.fsyncTask.close();
                return;
            }
            finally {
                this.fsyncTask = null;
            }
        } else if (this.fsyncTask == null) {
            this.fsyncTask = new AsyncTranslogFSync(this);
            return;
        } else {
            this.fsyncTask.updateIfNeeded();
        }
    }

    private void rescheduleRefreshTasks() {
        try {
            this.refreshTask.close();
        }
        finally {
            this.refreshTask = new AsyncRefreshTask(this);
        }
    }

    public final EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    @VisibleForTesting
    final IndexStorePlugin.DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    private void maybeFSyncTranslogs() {
        if (this.indexSettings.getTranslogDurability() == Translog.Durability.ASYNC) {
            for (IndexShard shard : this.shards.values()) {
                try {
                    if (!shard.isSyncNeeded()) continue;
                    shard.sync();
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (IOException e) {
                    this.logger.warn("failed to sync translog", (Throwable)e);
                }
            }
        }
    }

    private void maybeRefreshEngine(boolean force) {
        if (this.indexSettings.getRefreshInterval().millis() > 0L || force) {
            for (IndexShard shard : this.shards.values()) {
                try {
                    shard.scheduledRefresh();
                }
                catch (AlreadyClosedException | IndexShardClosedException throwable) {}
            }
        }
    }

    private void maybeTrimTranslog() {
        block6: for (IndexShard shard : this.shards.values()) {
            switch (shard.state()) {
                case CREATED: 
                case RECOVERING: 
                case CLOSED: {
                    continue block6;
                }
                case POST_RECOVERY: 
                case STARTED: {
                    try {
                        shard.trimTranslog();
                    }
                    catch (AlreadyClosedException | IndexShardClosedException throwable) {}
                    continue block6;
                }
            }
            throw new IllegalStateException("unknown state: " + shard.state());
        }
    }

    private void maybeSyncGlobalCheckpoints() {
        this.sync(is -> is.maybeSyncGlobalCheckpoint("background"), "global checkpoint");
    }

    private void syncRetentionLeases() {
        if (this.indexSettings.isSoftDeleteEnabled()) {
            this.sync(IndexShard::syncRetentionLeases, "retention lease");
        }
    }

    private void sync(Consumer<IndexShard> sync, String source) {
        block7: for (IndexShard shard : this.shards.values()) {
            if (!shard.routingEntry().active() || !shard.routingEntry().primary()) continue;
            switch (shard.state()) {
                case CREATED: 
                case RECOVERING: 
                case CLOSED: {
                    continue block7;
                }
                case POST_RECOVERY: {
                    assert (false) : "shard " + shard.shardId() + " is in post-recovery but marked as active";
                    continue block7;
                }
                case STARTED: {
                    try {
                        shard.runUnderPrimaryPermit(() -> sync.accept(shard), e -> {
                            if (!(e instanceof AlreadyClosedException) && !(e instanceof IndexShardClosedException)) {
                                this.logger.warn((Message)new ParameterizedMessage("{} failed to execute {} sync", (Object)shard.shardId(), (Object)source), (Throwable)e);
                            }
                        }, "same", source + " sync");
                    }
                    catch (AlreadyClosedException | IndexShardClosedException throwable) {}
                    continue block7;
                }
            }
            throw new IllegalStateException("unknown state [" + shard.state() + "]");
        }
    }

    AsyncRefreshTask getRefreshTask() {
        return this.refreshTask;
    }

    AsyncTranslogFSync getFsyncTask() {
        return this.fsyncTask;
    }

    AsyncTrimTranslogTask getTrimTranslogTask() {
        return this.trimTranslogTask;
    }

    public static enum IndexCreationContext {
        CREATE_INDEX,
        META_DATA_VERIFICATION;

    }

    public static interface ShardStoreDeleter {
        public void deleteShardStore(String var1, ShardLock var2, IndexSettings var3) throws IOException;

        public void addPendingDelete(ShardId var1, IndexSettings var2);
    }

    final class AsyncRefreshTask
    extends BaseAsyncTask {
        AsyncRefreshTask(IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getRefreshInterval());
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeRefreshEngine(false);
        }

        @Override
        protected String getThreadPool() {
            return "refresh";
        }

        public String toString() {
            return "refresh";
        }
    }

    final class AsyncTrimTranslogTask
    extends BaseAsyncTask {
        AsyncTrimTranslogTask(IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getSettings().getAsTime(IndexService.INDEX_TRANSLOG_RETENTION_CHECK_INTERVAL_SETTING, TimeValue.timeValueMinutes(10L)));
        }

        @Override
        protected boolean mustReschedule() {
            return !this.indexService.closed.get();
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeTrimTranslog();
        }

        @Override
        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "trim_translog";
        }
    }

    final class AsyncGlobalCheckpointTask
    extends BaseAsyncTask {
        AsyncGlobalCheckpointTask(IndexService indexService) {
            super(indexService, GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING.get(indexService.getIndexSettings().getSettings()));
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeSyncGlobalCheckpoints();
        }

        @Override
        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "global_checkpoint_sync";
        }
    }

    final class AsyncRetentionLeaseSyncTask
    extends BaseAsyncTask {
        AsyncRetentionLeaseSyncTask(IndexService indexService) {
            super(indexService, RETENTION_LEASE_SYNC_INTERVAL_SETTING.get(indexService.getIndexSettings().getSettings()));
        }

        @Override
        protected void runInternal() {
            this.indexService.syncRetentionLeases();
        }

        @Override
        protected String getThreadPool() {
            return "management";
        }

        public String toString() {
            return "retention_lease_sync";
        }
    }

    static final class AsyncTranslogFSync
    extends BaseAsyncTask {
        AsyncTranslogFSync(IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getTranslogSyncInterval());
        }

        @Override
        protected String getThreadPool() {
            return "flush";
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeFSyncTranslogs();
        }

        void updateIfNeeded() {
            TimeValue newInterval = this.indexService.getIndexSettings().getTranslogSyncInterval();
            if (!newInterval.equals(this.getInterval())) {
                this.setInterval(newInterval);
            }
        }

        public String toString() {
            return "translog_sync";
        }
    }

    private class StoreCloseListener
    implements Store.OnClose {
        private final ShardId shardId;
        private final Closeable[] toClose;

        StoreCloseListener(ShardId shardId, Closeable ... toClose) {
            this.shardId = shardId;
            this.toClose = toClose;
        }

        @Override
        public void accept(ShardLock lock) {
            try {
                assert (lock.getShardId().equals(this.shardId)) : "shard id mismatch, expected: " + this.shardId + " but got: " + lock.getShardId();
                IndexService.this.onShardClose(lock);
            }
            finally {
                try {
                    IOUtils.close(this.toClose);
                }
                catch (IOException ex) {
                    IndexService.this.logger.debug("failed to close resource", (Throwable)ex);
                }
            }
        }
    }

    static abstract class BaseAsyncTask
    extends AbstractAsyncTask {
        protected final IndexService indexService;

        BaseAsyncTask(IndexService indexService, TimeValue interval) {
            super(indexService.logger, indexService.threadPool, interval, true);
            this.indexService = indexService;
            this.rescheduleIfNecessary();
        }

        @Override
        protected boolean mustReschedule() {
            return !this.indexService.closed.get() && this.indexService.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN;
        }
    }
}

