/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;

public class MetaStateService {
    private static final Logger LOGGER = LogManager.getLogger(MetaStateService.class);
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;
    protected MetadataStateFormat<Metadata> META_DATA_FORMAT = Metadata.FORMAT;
    protected MetadataStateFormat<IndexMetadata> INDEX_META_DATA_FORMAT = IndexMetadata.FORMAT;
    protected MetadataStateFormat<Manifest> MANIFEST_FORMAT = Manifest.FORMAT;

    public MetaStateService(NodeEnvironment nodeEnv, NamedXContentRegistry namedXContentRegistry) {
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    Tuple<Manifest, Metadata> loadFullState() throws IOException {
        Metadata.Builder metadataBuilder;
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(LOGGER, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            return this.loadFullStateBWC();
        }
        if (manifest.isGlobalGenerationMissing()) {
            metadataBuilder = Metadata.builder();
        } else {
            Metadata globalMetadata = this.META_DATA_FORMAT.loadGeneration(LOGGER, this.namedXContentRegistry, manifest.getGlobalGeneration(), this.nodeEnv.nodeDataPaths());
            if (globalMetadata != null) {
                metadataBuilder = Metadata.builder(globalMetadata);
            } else {
                throw new IOException("failed to find global metadata [generation: " + manifest.getGlobalGeneration() + "]");
            }
        }
        for (Map.Entry<Index, Long> entry : manifest.getIndexGenerations().entrySet()) {
            String indexFolderName;
            Index index = entry.getKey();
            long generation = entry.getValue();
            IndexMetadata indexMetadata = this.INDEX_META_DATA_FORMAT.loadGeneration(LOGGER, this.namedXContentRegistry, generation, this.nodeEnv.resolveIndexFolder(indexFolderName = index.getUUID()));
            if (indexMetadata != null) {
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            throw new IOException("failed to find metadata for existing index " + index.getName() + " [location: " + indexFolderName + ", generation: " + generation + "]");
        }
        return new Tuple<Manifest, Metadata>(manifest, metadataBuilder.build());
    }

    private Tuple<Manifest, Metadata> loadFullStateBWC() throws IOException {
        HashMap<Index, Long> indices = new HashMap<Index, Long>();
        Tuple<Metadata, Long> metadataAndGeneration = this.META_DATA_FORMAT.loadLatestStateWithGeneration(LOGGER, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        Metadata globalMetadata = metadataAndGeneration.v1();
        long globalStateGeneration = metadataAndGeneration.v2();
        Metadata.Builder metadataBuilder = globalMetadata != null ? Metadata.builder(globalMetadata) : Metadata.builder();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            Tuple<IndexMetadata, Long> indexMetadataAndGeneration = this.INDEX_META_DATA_FORMAT.loadLatestStateWithGeneration(LOGGER, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            IndexMetadata indexMetadata = indexMetadataAndGeneration.v1();
            long generation = indexMetadataAndGeneration.v2();
            if (indexMetadata != null) {
                indices.put(indexMetadata.getIndex(), generation);
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            LOGGER.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        Manifest manifest = Manifest.unknownCurrentTermAndVersion(globalStateGeneration, indices);
        return new Tuple<Manifest, Metadata>(manifest, metadataBuilder.build());
    }

    @Nullable
    public IndexMetadata loadIndexState(Index index) throws IOException {
        return this.INDEX_META_DATA_FORMAT.loadLatestState(LOGGER, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetadata> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetadata indexMetadata = this.INDEX_META_DATA_FORMAT.loadLatestState(LOGGER, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetadata != null) {
                String indexPathId = indexMetadata.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetadataList.add(indexMetadata);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            LOGGER.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetadataList;
    }

    public Manifest loadManifestOrEmpty() throws IOException {
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(LOGGER, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            manifest = Manifest.empty();
        }
        return manifest;
    }

    Metadata loadGlobalState() throws IOException {
        return this.META_DATA_FORMAT.loadLatestState(LOGGER, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public void writeManifestAndCleanup(String reason, Manifest manifest) throws WriteStateException {
        LOGGER.trace("[_meta] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.MANIFEST_FORMAT.writeAndCleanup(manifest, this.nodeEnv.nodeDataPaths());
            LOGGER.trace("[_meta] state written (generation: {})", (Object)generation);
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(ex.isDirty(), "[_meta]: failed to write meta state", ex);
        }
    }

    public long writeIndex(String reason, IndexMetadata indexMetadata) throws WriteStateException {
        Index index = indexMetadata.getIndex();
        LOGGER.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            long generation = this.INDEX_META_DATA_FORMAT.write(indexMetadata, this.nodeEnv.indexPaths(indexMetadata.getIndex()));
            LOGGER.trace("[{}] state written", (Object)index);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[" + index + "]: failed to write index state", ex);
        }
    }

    long writeGlobalState(String reason, Metadata metadata) throws WriteStateException {
        LOGGER.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.META_DATA_FORMAT.write(metadata, this.nodeEnv.nodeDataPaths());
            LOGGER.trace("[_global] state written");
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[_global]: failed to write global state", ex);
        }
    }

    void cleanupGlobalState(long currentGeneration) {
        this.META_DATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.nodeDataPaths());
    }

    public void cleanupIndex(Index index, long currentGeneration) {
        this.INDEX_META_DATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.indexPaths(index));
    }

    public void writeIndexAndUpdateManifest(String reason, IndexMetadata metadata) throws IOException {
        long generation = this.writeIndex(reason, metadata);
        Manifest manifest = this.loadManifestOrEmpty();
        HashMap<Index, Long> indices = new HashMap<Index, Long>(manifest.getIndexGenerations());
        indices.put(metadata.getIndex(), generation);
        manifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), manifest.getGlobalGeneration(), indices);
        this.writeManifestAndCleanup(reason, manifest);
        this.cleanupIndex(metadata.getIndex(), generation);
    }

    public void writeGlobalStateAndUpdateManifest(String reason, Metadata metadata) throws IOException {
        long generation = this.writeGlobalState(reason, metadata);
        Manifest manifest = this.loadManifestOrEmpty();
        manifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), generation, manifest.getIndexGenerations());
        this.writeManifestAndCleanup(reason, manifest);
        this.cleanupGlobalState(generation);
    }
}

