/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.collections.Tuple;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.IncrementalClusterStateWriter;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.transport.TransportService;

public class GatewayMetaState {
    private static final Logger LOGGER = LogManager.getLogger(GatewayMetaState.class);
    private final SetOnce<CoordinationState.PersistedState> persistedState = new SetOnce();

    public CoordinationState.PersistedState getPersistedState() {
        CoordinationState.PersistedState persistedState = (CoordinationState.PersistedState)this.persistedState.get();
        assert (persistedState != null) : "not started";
        return persistedState;
    }

    public Metadata getMetadata() {
        return this.getPersistedState().getLastAcceptedState().metadata();
    }

    public void start(Settings settings, TransportService transportService, ClusterService clusterService, MetaStateService metaStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        Tuple<Manifest, ClusterState> manifestClusterStateTuple;
        assert (this.persistedState.get() == null) : "should only start once, but already have " + this.persistedState.get();
        try {
            this.upgradeMetadata(settings, metaStateService, metadataIndexUpgradeService, metadataUpgrader);
            manifestClusterStateTuple = GatewayMetaState.loadStateAndManifest(ClusterName.CLUSTER_NAME_SETTING.get(settings), metaStateService);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
        }
        IncrementalClusterStateWriter incrementalClusterStateWriter = new IncrementalClusterStateWriter(settings, clusterService.getClusterSettings(), metaStateService, manifestClusterStateTuple.v1(), this.prepareInitialClusterState(transportService, clusterService, manifestClusterStateTuple.v2()), transportService.getThreadPool()::relativeTimeInMillis);
        if (!DiscoveryNode.isMasterNode(settings)) {
            if (DiscoveryNode.isDataNode(settings)) {
                clusterService.addLowPriorityApplier(new GatewayClusterApplier(incrementalClusterStateWriter));
            }
            this.persistedState.set((Object)new InMemoryPersistedState(manifestClusterStateTuple.v1().getCurrentTerm(), manifestClusterStateTuple.v2()));
        } else {
            this.persistedState.set((Object)new GatewayPersistedState(incrementalClusterStateWriter));
        }
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        assert (clusterState.nodes().getLocalNode() == null) : "prepareInitialClusterState must only be called once";
        assert (transportService.getLocalNode() != null) : "transport service is not yet started";
        return Function.identity().andThen(ClusterStateUpdaters::addStateNotRecoveredBlock).andThen(state -> ClusterStateUpdaters.setLocalNode(state, transportService.getLocalNode())).andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, clusterService.getClusterSettings())).andThen(ClusterStateUpdaters::recoverClusterBlocks).apply(clusterState);
    }

    void upgradeMetadata(Settings settings, MetaStateService metaStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) throws IOException {
        if (GatewayMetaState.isMasterOrDataNode(settings)) {
            try {
                Tuple<Manifest, Metadata> metaStateAndData = metaStateService.loadFullState();
                Manifest manifest = metaStateAndData.v1();
                Metadata metadata = metaStateAndData.v2();
                IncrementalClusterStateWriter.AtomicClusterStateWriter writer = new IncrementalClusterStateWriter.AtomicClusterStateWriter(metaStateService, manifest);
                Metadata upgradedMetadata = GatewayMetaState.upgradeMetadata(metadata, metadataIndexUpgradeService, metadataUpgrader);
                long globalStateGeneration = !Metadata.isGlobalStateEquals(metadata, upgradedMetadata) ? writer.writeGlobalState("upgrade", upgradedMetadata) : manifest.getGlobalGeneration();
                HashMap<Index, Long> indices = new HashMap<Index, Long>(manifest.getIndexGenerations());
                for (IndexMetadata indexMetadata : upgradedMetadata) {
                    if (metadata.hasIndexMetadata(indexMetadata)) continue;
                    long generation = writer.writeIndex("upgrade", indexMetadata);
                    indices.put(indexMetadata.getIndex(), generation);
                }
                Manifest newManifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), globalStateGeneration, indices);
                writer.writeManifestAndCleanup("startup", newManifest);
            }
            catch (Exception e) {
                LOGGER.error("failed to read or upgrade local state, exiting...", (Throwable)e);
                throw e;
            }
        }
    }

    private static Tuple<Manifest, ClusterState> loadStateAndManifest(ClusterName clusterName, MetaStateService metaStateService) throws IOException {
        long startNS = System.nanoTime();
        Tuple<Manifest, Metadata> manifestAndMetadata = metaStateService.loadFullState();
        Manifest manifest = manifestAndMetadata.v1();
        ClusterState clusterState = ClusterState.builder(clusterName).version(manifest.getClusterStateVersion()).metadata(manifestAndMetadata.v2()).build();
        LOGGER.debug("took {} to load state", (Object)TimeValue.timeValueMillis(TimeValue.nsecToMSec(System.nanoTime() - startNS)));
        return Tuple.tuple(manifest, clusterState);
    }

    private static boolean isMasterOrDataNode(Settings settings) {
        return DiscoveryNode.isMasterNode(settings) || DiscoveryNode.isDataNode(settings);
    }

    static Metadata upgradeMetadata(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        boolean changed = false;
        Metadata.Builder upgradedMetadata = Metadata.builder(metadata);
        for (IndexMetadata indexMetadata : metadata) {
            IndexMetadata newMetadata;
            changed |= indexMetadata != (newMetadata = metadataIndexUpgradeService.upgradeIndexMetadata(indexMetadata, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetadata.put(newMetadata, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metadata.getCustoms(), metadataUpgrader.customMetadataUpgraders, upgradedMetadata::removeCustom, upgradedMetadata::putCustom)) {
            changed = true;
        }
        if (GatewayMetaState.applyPluginUpgraders(metadata.getTemplates(), metadataUpgrader.indexTemplateMetadataUpgraders, upgradedMetadata::removeTemplate, (s, indexTemplateMetadata) -> upgradedMetadata.put((IndexTemplateMetadata)indexTemplateMetadata))) {
            changed = true;
        }
        return changed ? upgradedMetadata.build() : metadata;
    }

    private static <Data> boolean applyPluginUpgraders(ImmutableOpenMap<String, Data> existingData, UnaryOperator<Map<String, Data>> upgrader, Consumer<String> removeData, BiConsumer<String, Data> putData) {
        HashMap<String, Object> existingMap = new HashMap<String, Object>();
        for (ObjectObjectCursor<String, Data> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    private static class GatewayClusterApplier
    implements ClusterStateApplier {
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        private GatewayClusterApplier(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public void applyClusterState(ClusterChangedEvent event) {
            if (event.state().blocks().disableStatePersistence()) {
                this.incrementalClusterStateWriter.setIncrementalWrite(false);
                return;
            }
            try {
                if (event.state().term() > this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm()) {
                    this.incrementalClusterStateWriter.setCurrentTerm(event.state().term());
                }
                this.incrementalClusterStateWriter.updateClusterState(event.state(), event.previousState());
                this.incrementalClusterStateWriter.setIncrementalWrite(true);
            }
            catch (WriteStateException e) {
                LOGGER.warn("Exception occurred when storing new meta data", (Throwable)e);
            }
        }
    }

    private static class GatewayPersistedState
    implements CoordinationState.PersistedState {
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        GatewayPersistedState(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public long getCurrentTerm() {
            return this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm();
        }

        @Override
        public ClusterState getLastAcceptedState() {
            ClusterState previousClusterState = this.incrementalClusterStateWriter.getPreviousClusterState();
            assert (previousClusterState.nodes().getLocalNode() != null) : "Cluster state is not fully built yet";
            return previousClusterState;
        }

        @Override
        public void setCurrentTerm(long currentTerm) {
            try {
                this.incrementalClusterStateWriter.setCurrentTerm(currentTerm);
            }
            catch (WriteStateException e) {
                LOGGER.error((Message)new ParameterizedMessage("Failed to set current term to {}", (Object)currentTerm), (Throwable)e);
                e.rethrowAsErrorOrUncheckedException();
            }
        }

        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            try {
                ClusterState previousClusterState = this.incrementalClusterStateWriter.getPreviousClusterState();
                this.incrementalClusterStateWriter.setIncrementalWrite(previousClusterState.term() == clusterState.term());
                this.incrementalClusterStateWriter.updateClusterState(clusterState, previousClusterState);
            }
            catch (WriteStateException e) {
                LOGGER.error((Message)new ParameterizedMessage("Failed to set last accepted state with version {}", (Object)clusterState.version()), (Throwable)e);
                e.rethrowAsErrorOrUncheckedException();
            }
        }
    }
}

