/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.PrimaryShardAllocator;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetadata;

public class GatewayAllocator {
    private static final Logger LOGGER = LogManager.getLogger(GatewayAllocator.class);
    private final RerouteService rerouteService;
    private final PrimaryShardAllocator primaryShardAllocator;
    private final ReplicaShardAllocator replicaShardAllocator;
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> asyncFetchStarted = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>> asyncFetchStore = ConcurrentCollections.newConcurrentMap();
    private Set<String> lastSeenEphemeralIds = Collections.emptySet();

    @Inject
    public GatewayAllocator(RerouteService rerouteService, NodeClient client) {
        this.rerouteService = rerouteService;
        this.primaryShardAllocator = new InternalPrimaryShardAllocator(client);
        this.replicaShardAllocator = new InternalReplicaShardAllocator(client);
    }

    public void cleanCaches() {
        Releasables.close(this.asyncFetchStarted.values());
        this.asyncFetchStarted.clear();
        Releasables.close(this.asyncFetchStore.values());
        this.asyncFetchStore.clear();
    }

    protected GatewayAllocator() {
        this.rerouteService = null;
        this.primaryShardAllocator = null;
        this.replicaShardAllocator = null;
    }

    public int getNumberOfInFlightFetch() {
        int count = 0;
        for (AsyncShardFetch fetch : this.asyncFetchStarted.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        for (AsyncShardFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        return count;
    }

    public void applyStartedShards(RoutingAllocation allocation, List<ShardRouting> startedShards) {
        for (ShardRouting startedShard : startedShards) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(startedShard.shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(startedShard.shardId()));
        }
    }

    public void applyFailedShards(RoutingAllocation allocation, List<FailedShard> failedShards) {
        for (FailedShard failedShard : failedShards) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(failedShard.getRoutingEntry().shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(failedShard.getRoutingEntry().shardId()));
        }
    }

    public void allocateUnassigned(RoutingAllocation allocation) {
        assert (this.primaryShardAllocator != null);
        assert (this.replicaShardAllocator != null);
        this.ensureAsyncFetchStorePrimaryRecency(allocation);
        GatewayAllocator.innerAllocatedUnassigned(allocation, this.primaryShardAllocator, this.replicaShardAllocator);
    }

    protected static void innerAllocatedUnassigned(RoutingAllocation allocation, PrimaryShardAllocator primaryShardAllocator, ReplicaShardAllocator replicaShardAllocator) {
        RoutingNodes.UnassignedShards unassigned = allocation.routingNodes().unassigned();
        unassigned.sort(PriorityComparator.getAllocationComparator(allocation));
        primaryShardAllocator.allocateUnassigned(allocation);
        if (allocation.routingNodes().hasInactiveShards()) {
            replicaShardAllocator.processExistingRecoveries(allocation);
        }
        replicaShardAllocator.allocateUnassigned(allocation);
    }

    public AllocateUnassignedDecision decideUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation routingAllocation) {
        if (unassignedShard.primary()) {
            assert (this.primaryShardAllocator != null);
            return this.primaryShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, LOGGER);
        }
        assert (this.replicaShardAllocator != null);
        return this.replicaShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, LOGGER);
    }

    private void ensureAsyncFetchStorePrimaryRecency(RoutingAllocation allocation) {
        DiscoveryNodes nodes = allocation.nodes();
        if (this.hasNewNodes(nodes)) {
            Set newEphemeralIds = StreamSupport.stream(nodes.getDataNodes().spliterator(), false).map(node -> ((DiscoveryNode)node.value).getEphemeralId()).collect(Collectors.toSet());
            LOGGER.trace(() -> new ParameterizedMessage("new nodes {} found, clearing primary async-fetch-store cache", Sets.difference(newEphemeralIds, this.lastSeenEphemeralIds)));
            this.asyncFetchStore.values().forEach(fetch -> GatewayAllocator.clearCacheForPrimary(fetch, allocation));
            this.lastSeenEphemeralIds = newEphemeralIds;
        }
    }

    private static void clearCacheForPrimary(AsyncShardFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetch, RoutingAllocation allocation) {
        ShardRouting primary = allocation.routingNodes().activePrimary(fetch.shardId);
        if (primary != null) {
            fetch.clearCacheForNode(primary.currentNodeId());
        }
    }

    private boolean hasNewNodes(DiscoveryNodes nodes) {
        for (ObjectObjectCursor<String, DiscoveryNode> objectObjectCursor : nodes.getDataNodes()) {
            if (this.lastSeenEphemeralIds.contains(((DiscoveryNode)objectObjectCursor.value).getEphemeralId())) continue;
            return true;
        }
        return false;
    }

    class InternalPrimaryShardAllocator
    extends PrimaryShardAllocator {
        private final NodeClient client;

        InternalPrimaryShardAllocator(NodeClient client) {
            this.client = client;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch.Lister lister = this::listStartedShards;
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStarted.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch(this.logger, "shard_started", (ShardId)shardId, lister));
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = fetch.fetchData(allocation.nodes(), allocation.getIgnoreNodes(shard.shardId()));
            if (shardState.hasData()) {
                shardState.processAllocation(allocation);
            }
            return shardState;
        }

        private void listStartedShards(ShardId shardId, DiscoveryNode[] nodes, ActionListener<BaseNodesResponse<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> listener) {
            TransportNodesListGatewayStartedShards.Request request = new TransportNodesListGatewayStartedShards.Request(shardId, nodes);
            this.client.executeLocally(TransportNodesListGatewayStartedShards.TYPE, request, ActionListener.wrap(listener::onResponse, listener::onFailure));
        }
    }

    class InternalReplicaShardAllocator
    extends ReplicaShardAllocator {
        private final NodeClient client;

        InternalReplicaShardAllocator(NodeClient client) {
            this.client = client;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch.Lister lister = this::listStoreFilesMetadata;
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStore.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch(this.logger, "shard_store", shard.shardId(), lister));
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores = fetch.fetchData(allocation.nodes(), allocation.getIgnoreNodes(shard.shardId()));
            if (shardStores.hasData()) {
                shardStores.processAllocation(allocation);
            }
            return shardStores;
        }

        private void listStoreFilesMetadata(ShardId shardId, DiscoveryNode[] nodes, ActionListener<BaseNodesResponse<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>> listener) {
            TransportNodesListShardStoreMetadata.Request request = new TransportNodesListShardStoreMetadata.Request(shardId, nodes);
            this.client.executeLocally(TransportNodesListShardStoreMetadata.TYPE, request, ActionListener.wrap(listener::onResponse, listener::onFailure));
        }

        @Override
        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return GatewayAllocator.this.asyncFetchStore.get(shard.shardId()) != null;
        }
    }

    class InternalAsyncFetch<T extends BaseNodeResponse>
    extends AsyncShardFetch<T> {
        InternalAsyncFetch(Logger logger, String type, ShardId shardId, AsyncShardFetch.Lister<? extends BaseNodesResponse<T>, T> action) {
            super(logger, type, shardId, action);
        }

        @Override
        protected void reroute(ShardId shardId, String reason) {
            this.logger.trace("{} scheduling reroute for {}", (Object)shardId, (Object)reason);
            assert (GatewayAllocator.this.rerouteService != null);
            GatewayAllocator.this.rerouteService.reroute("async_shard_fetch", Priority.HIGH, ActionListener.wrap(r -> this.logger.trace("{} scheduled reroute completed for {}", (Object)shardId, (Object)reason), e -> this.logger.debug((Message)new ParameterizedMessage("{} scheduled reroute failed for {}", (Object)shardId, (Object)reason), (Throwable)e)));
        }
    }
}

