/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;

public class Gateway {
    private static final Logger LOGGER = LogManager.getLogger(Gateway.class);
    private final ClusterService clusterService;
    private final NodeClient client;

    public Gateway(ClusterService clusterService, NodeClient client) {
        this.clusterService = clusterService;
        this.client = client;
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        Object[] nodes = (DiscoveryNode[])this.clusterService.state().nodes().getMasterNodes().values().toArray(DiscoveryNode.class);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("performing state recovery from {}", (Object)Arrays.toString(nodes));
        }
        TransportNodesListGatewayMetaState.Request request = new TransportNodesListGatewayMetaState.Request((DiscoveryNode[])nodes);
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.client.executeLocally(TransportNodesListGatewayMetaState.TYPE, request, future);
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = (TransportNodesListGatewayMetaState.NodesGatewayMetaState)future.actionGet();
        boolean requiredAllocation = true;
        if (nodesState.hasFailures()) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                LOGGER.warn("failed to fetch state from node", (Throwable)failedNodeException);
            }
        }
        ObjectFloatHashMap indices = new ObjectFloatHashMap();
        Metadata electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
            if (nodeState.metadata() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metadata();
            } else if (nodeState.metadata().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metadata();
            }
            for (ObjectCursor cursor : nodeState.metadata().indices().values()) {
                indices.addTo((Object)((IndexMetadata)cursor.value).getIndex(), 1.0f);
            }
        }
        if (found < 1) {
            listener.onFailure("found [" + found + "] metadata states, required [1]");
            return;
        }
        Metadata.Builder metadataBuilder = Metadata.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keys;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            Index index = (Index)keys[i];
            IndexMetadata electedIndexMetadata = null;
            int indexMetadataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
                IndexMetadata indexMetadata;
                if (nodeState.metadata() == null || (indexMetadata = nodeState.metadata().index(index)) == null) continue;
                if (electedIndexMetadata == null) {
                    electedIndexMetadata = indexMetadata;
                } else if (indexMetadata.getVersion() > electedIndexMetadata.getVersion()) {
                    electedIndexMetadata = indexMetadata;
                }
                ++indexMetadataCount;
            }
            if (electedIndexMetadata == null) continue;
            if (indexMetadataCount < 1) {
                LOGGER.debug("[{}] found [{}], required [{}], not adding", (Object)index, (Object)indexMetadataCount, (Object)1);
            }
            metadataBuilder.put(electedIndexMetadata, false);
        }
        ClusterState recoveredState = Function.identity().andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, this.clusterService.getClusterSettings())).apply(ClusterState.builder(this.clusterService.getClusterName()).metadata(metadataBuilder).build());
        listener.onSuccess(recoveredState);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

